<?php
/*
	Template Name: Home
*/

get_header('custom'); ?>

<?php get_template_part('parts/part', 'videobanner'); ?>

<section class="home-about">
    <div class="container">
        <div class="row">
            <div class="col-md-6 col-xs-12 world-touch">
                <h2 class="section-title"><?php echo get_field('about_title'); ?></h2>
                <div class="info"><?php echo get_field('about_content'); ?></div>
                <div class="container">
                    <?php if( have_rows('statistics') ): ?>
                    <div class="numbers row">
                        <?php while( have_rows('statistics') ): the_row(); ?>
                        <div class="number col-md-4 col-sm-6 col-xs-6">
                            <div class="number-item"><?php echo get_sub_field('number'); ?></div>
                            <span class="desc"><?php echo get_sub_field('description'); ?></span>
                        </div>	
                        <?php endwhile; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6 col-xs-12 circle-animation">
                <div class="circles-wrap">
                    <img src="<?php echo get_stylesheet_directory_uri() ?>/images/new/home-panel-2-ring-outer.svg" alt="" class="circle-extra-outer">
                    <img src="<?php echo get_stylesheet_directory_uri() ?>/images/new/home-panel-2-ring-inner.svg" alt="" class="circle-outer">
                    <div class="img-wrap">
                        <?php 
                            $side_image0 = explode("{:}", get_field('about_image', get_the_ID(), false));
                            $langs = $side_image0;

                            foreach ($langs as $lang) {
                                $phrase  = $side_image0;
                                $healthy = array("{:en}", "{:ja}", "{:zh}");
                                $yummy   = array("", "");
                                $newphrase = str_replace($healthy, $yummy, $phrase);
                            }
                            if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                        ?>
                        <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="devices-img"/>
                        <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="devices-img"/>
                        <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="devices-img"/>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php echo get_template_part('parts/part', 'panels'); ?>

<section class="home-news container-padding">
    <div class="container">
        <div class="row">
            <?php if( have_rows('announcements') ): ?>
            <?php while( have_rows('announcements') ): the_row();?>
            <?php 
                $side_image = explode("{:}", get_sub_field('background_image', false));
                $langs = $side_image;

                foreach ($langs as $lang) {
                    $phrase  = $side_image;
                    $healthy = array("{:en}", "{:ja}",  "{:zh}");
                    $yummy   = array("", "");
                    $newphrase = str_replace($healthy, $yummy, $phrase);
                }
                if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
            ?>
            <?php if ( WPGlobus::Config()->language == 'ja' ) { 
              $bg = wp_get_attachment_url( ($newphrase[$num]) );
            } else if ( WPGlobus::Config()->language == 'zh' ) { 
                $bg = wp_get_attachment_url( ($newphrase[$num]) );
            } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { 
              $bg = wp_get_attachment_url( ($newphrase[0]) );
            } ?>
            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                <div class="news-box" style="background-image: url('<?php echo $bg; ?>');">
                    <a href="<?php echo get_sub_field('link'); ?>" target="_blank">
                        <div class="text-wrap">
                            <span class="title"><?php echo get_sub_field('title'); ?></span>
                            <span class="button button-fill learn-more cta-button"><span><?php echo get_sub_field('button_text'); ?></span></span>
                        </div>
                    </a>
                </div>
            </div>
            
            <?php endwhile; ?>
            <?php endif; ?>		
        </div>
    </div>
</section>

<section class="section-technology">
    <div class="container"> 
        <div class="row content-intro">
            <h2 class="section-title"><?php echo get_field('technology_title'); ?></h2>
            <div class="desc">
                <?php echo get_field('technology_content'); ?>
            </div>
        </div>
        <div class="row links-wrap button-animation">
            <?php if( have_rows('solutions') ): ?>
            <?php  $count=1; while( have_rows('solutions') ): the_row(); ?>
            
                <?php if($count==1||$count==3) { ?> 
                <div class="link-item col-lg-6 col-md-6 col-sm-12 col-xs-12">
                    <a href="<?php echo get_sub_field('link'); ?>" class="technology-icon float-right">
                        <?php 
                            $side_image1 = explode("{:}", get_sub_field('icon', false));
                            $langs = $side_image1;

                            foreach ($langs as $lang) {
                                $phrase  = $side_image1;
                                $healthy = array("{:en}", "{:ja}", "{:zh}");
                                $yummy   = array("", "");
                                $newphrase = str_replace($healthy, $yummy, $phrase);
                            }
                            if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                        ?>
                        <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="icon"/>
                        <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="icon"/>
                        <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="icon"/>
                        <?php } ?>
                    </a>
                    <a href="<?php echo get_sub_field('link'); ?>" class="icon-link float-right">
                        <?php echo get_sub_field('line1'); ?><br><?php echo get_sub_field('line2'); ?>
                    </a>
                </div>
                <?php } else if($count==2||$count==4) { ?>
                <div class="link-item col-lg-6 col-md-6 col-sm-12 col-xs-12">
                    <a href="<?php echo get_sub_field('link'); ?>" class="technology-icon float-left">
                        <?php 
                            $side_image1 = explode("{:}", get_sub_field('icon', false));
                            $langs = $side_image1;

                            foreach ($langs as $lang) {
                                $phrase  = $side_image1;
                                $healthy = array("{:en}", "{:ja}", "{:zh}");
                                $yummy   = array("", "");
                                $newphrase = str_replace($healthy, $yummy, $phrase);
                            }
                            if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                        ?>
                        <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="icon"/>
                        <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="icon"/>
                        <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="icon"/>
                        <?php } ?>
                    </a>
                    <a href="<?php echo get_sub_field('link'); ?>" class="icon-link float-left">
                        <?php echo get_sub_field('line1'); ?><br><?php echo get_sub_field('line2'); ?>
                    </a>
                </div>
                <?php } ?>
            <?php $count++; endwhile; ?>
            <?php endif; ?>								
        </div>
    </div>
</section>

<section class="home-partners container-padding">
    <div class="container">
        <?php if( have_rows('partner__certified') ): 
        $count = 0; ?>
            <?php while( have_rows('partner__certified') ): the_row();?>
            
            <div class="row">
                <div class="table-row col <?php if($count == 1) { echo 'second-row'; }?>">
                    <?php 
                        $side_image2 = explode("{:}", get_sub_field('image', false));
                        $langs = $side_image2;

                        foreach ($langs as $lang) {
                            $phrase  = $side_image2;
                            $healthy = array("{:en}", "{:ja}", "{:zh}");
                            $yummy   = array("", "");
                            $newphrase = str_replace($healthy, $yummy, $phrase);
                        }
                        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                    ?>
                    <?php if ( WPGlobus::Config()->language == 'ja' ) { 
                      $bg = wp_get_attachment_url( ($newphrase[$num]) );
                    } else if ( WPGlobus::Config()->language == 'zh' ) { 
                      $bg = wp_get_attachment_url( ($newphrase[$num]) );
                    } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { 
                      $bg = wp_get_attachment_url( ($newphrase[0]) );
                    } ?>
                    
                    <?php if($count == 0) {?>
                    <div class="cell cell-img col-md-6 col-sm-12 col-xs-12" style="background-image:url('<?php echo $bg; ?>);'"></div>
                    <?php } ?>
                    <div class="cell cell-txt col-md-6 col-sm-12 col-xs-12 <?php if($count == 1) { echo 'second-row-content'; }?>">
                        <div class="wrap">
                            <h3 class="section-title"><?php echo get_sub_field('title'); ?></h3>
                            <?php echo get_sub_field('content'); ?>
                            <p><a class="cta-link" href="<?php echo get_sub_field('link_url'); ?>"><?php echo get_sub_field('link_text'); ?></a></p>
                        </div>
                    </div>
                    <?php if($count == 1) {?>
                    <div class="cell cell-img col-md-6 col-sm-12 col-xs-12 second-row-image" style="background-image:url('<?php echo $bg; ?>);'"></div>
                    <?php } ?>
                </div>
            </div>
            <?php $count++; endwhile; ?>
        <?php endif; ?>
    </div>
</section>

<?php echo get_template_part('parts/part', 'innovation'); ?>
<?php echo get_template_part('parts/part', 'cta'); ?>
<?php get_footer('custom'); ?>

