<?php
/*
	Template Name: Technology
*/

get_header('custom'); ?>

<section class="technology-device container-padding">
    <div class="container">
        <div class="row">
            <div class="page-title"><?php echo get_field('top_section_title'); ?></div>
        </div>
        <div class="row description">
            <div class="col-md-4 col-sm-12 col-xs-12">
                <h2><?php echo get_field('top_section_subtitle'); ?></h2>
            </div>
            <div class="col-md-8 col-sm-12 col-xs-12">
                <div class="desc">
                    <?php echo get_field('top_section_description'); ?>
                </div>
            </div>
        </div>
        <div class="row links-wrap button-animation">
            <?php if( have_rows('solutions') ): ?>
            <?php while( have_rows('solutions') ): the_row();?>
            <div class="link-item col">
                <a href="#<?php echo get_sub_field('href'); ?>" title="<?php echo get_sub_field('line1'); ?> <?php echo get_sub_field('line2'); ?>" class="icon-link scroll">
                    <div class="button-wrap">
                        <svg class="outer-circle-wrap" width="110" height="120" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="outer circle-outer-1" id="circle-outer-1" d="M59,5c30.38,0,56,24.62,56,55s-24.62,55-55,55S5,90.38,5,60S28.62,5,59,5z" fill-rule="nonzero" fill="#070707" />
                            <path class="outer blob-outer-1" id="blob-outer-1" d="M13.55,38.75C23.58,8.8,64.45,12.25,89.5,14.53c27.25,2.48,34.29,40.4,8.58,62.43 	c-18.64,15.98-35.86,41.94-59.19,28.38S-0.57,80.91,13.55,38.75z" fill-rule="nonzero" />
                        </svg>
                        <svg class="inner-circle-wrap" width="110" height="120" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="inner circle-inner-1" id="circle-inner-1" d="M59,15c24.85,0,46,20.15,46,45s-20.15,45-45,45S15,84.85,15,60S34.15,15,59,15z" fill-rule="nonzero" />
                            <path class="inner blob-inner-1" id="blob-inner-1" d="M10.27,59.49C30.64,39.13,25.28,6.97,58.51,11.26c26.42,3.41,33.22,14.83,42.88,39.66 c15.01,38.59-9.81,49.31-36.45,49.31S-8.57,78.33,10.27,59.49z" />
                        </svg>
                        <div class="button-touch">
                             <?php 
                                $side_image = explode("{:}", get_sub_field('icon', false));
                                $langs = $side_image;

                                foreach ($langs as $lang) {
                                    $phrase  = $side_image;
                                    $healthy = array("{:en}", "{:ja}");
                                    $yummy   = array("", "");

                                    $newphrase = str_replace($healthy, $yummy, $phrase);
                                }
                                if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                            ?>
                            <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                              <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="icon"/>
                            <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                              <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="icon"/>
                            <?php } ?>
                        </div>
                    </div>
                    <span class="title"><?php echo get_sub_field('line1'); ?><br><?php echo get_sub_field('line2'); ?></span>
                </a>
            </div>
            <?php endwhile; ?>
            <?php endif; ?>										
        </div>
    </div>
</section>

<section class="technology-optimized container-padding" id="<?php echo get_field('id1'); ?>">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-12 image-container">
                <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/optimized.jpg" alt="Immersion">
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12">
                <h2 class="title-teal"><?php echo get_field('optimized_title'); ?></h2>
                <?php echo get_field('optimized_content'); ?>
                <div class="note"><?php echo get_field('optimized_note'); ?></div>
            </div>
        </div>
    </div>
</section>

<section class="technology-active container-padding" id="<?php echo get_field('id-activesensing'); ?>">
    <div class="active-content-left-bg"></div>
    <div class="container">
        <div class="row">
            <div class="col-lg-5 col-md-12 col-sm-12 active-content-left">
                <h2 class="title-teal"><?php echo get_field('active_sensing_title'); ?></h2>
                <p class="subtitle"><?php echo get_field('active_sensing_subtitle'); ?></p>
                <div class="active-sensing-content">
                    <?php echo get_field('active_sensing_content'); ?>
                </div>
                <a class="arrow-link" href="<?php echo get_field('active_sensing_link'); ?>"><?php echo get_field('active_sensing_link_text'); ?></a>
            </div>
            <div class="col-lg-7 col-md-12 col-sm-12 active-content-right">
                <img class="active-sensing-image" src="<?php echo get_field('active_sensing_image'); ?>" alt="Active Sensing Technology"/>
                <h3 class="title-teal"><?php echo get_field('active_recalibration_text'); ?></h3>
                <div class="row">
                    <?php if( have_rows('active_recalibration') ): ?>
                    <?php while( have_rows('active_recalibration') ): the_row(); ?>
                    <div class="col-lg-6 col-md-6 col-sm-12 recalibration-content">
                        <h4 class="title-white"><?php echo get_sub_field('active_recalibration_title'); ?></h4>
                        <?php echo get_sub_field('active_recalibration_description'); ?>
                    </div>
                    <?php endwhile; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php/*?>
<section class="technology-integration-2" id="<?php echo get_field('id2'); ?>">
    <div class="container">
        <div class="row">
            <div class="download-link col-lg-5">
                <div class="integration-image">
                 <img src="<?php echo get_field('integration_image'); ?>" alt="Haptic Integration"/>
                </div>
                <span class="title-cta"><?php echo get_field('download_title'); ?></span>
                <span><?php echo get_field('download_cta'); ?></span>
                <a href="<?php echo get_field('download_link'); ?>" target="_blank"><?php echo get_field('download_button'); ?></a>
            </div>
            <div class="integration-text container-padding col-lg-7">
                <h2 class="title-teal"><?php echo get_field('integration_title'); ?></h2>
                <?php echo get_field('integration_content'); ?>
                <div class="integration-list">
                    
                    <?php if( have_rows('integration_benefits') ): ?>
                    <?php while( have_rows('integration_benefits') ): the_row(); ?>
                    <div class="row">
                        <?php if( have_rows('row') ): ?>
                        <?php while( have_rows('row') ): the_row(); ?>
                        <div class="col">
                            <h3 class="title-black"><?php echo get_sub_field('title'); ?></h3>
                            <?php echo get_sub_field('description'); ?>
                        </div>
                        <?php endwhile; ?>
                        <?php endif; ?>
                    </div>
                    <?php endwhile; ?>
                    <?php endif; ?>
                    
                </div>
            </div>
        </div>
    </div>
</section>

<section class="technology-integration" id="<?php echo get_field('id2'); ?>">
    <div class="container">
        <div class="row">
            <div class="integration-text container-padding col-lg-8">
                <h2 class="title-teal"><?php echo get_field('integration_title'); ?></h2>
                <?php echo get_field('integration_content'); ?>
                <div class="integration-list">
                    
                    <?php if( have_rows('integration_benefits') ): ?>
                    <?php while( have_rows('integration_benefits') ): the_row(); ?>
                    <div class="row">
                        <?php if( have_rows('row') ): ?>
                        <?php while( have_rows('row') ): the_row(); ?>
                        <div class="col">
                            <h3 class="title-black"><?php echo get_sub_field('title'); ?></h3>
                            <?php echo get_sub_field('description'); ?>
                        </div>
                        <?php endwhile; ?>
                        <?php endif; ?>
                    </div>
                    <?php endwhile; ?>
                    <?php endif; ?>
                    
                </div>
            </div>
            <div class="download-link col-lg-4">
                 <?php 
                    $side_image2 = explode("{:}", get_field('haptic_integration_icon', get_the_ID(), false));
                    $langs = $side_image2;

                    foreach ($langs as $lang) {
                        $phrase  = $side_image2;
                        $healthy = array("{:en}", "{:ja}");
                        $yummy   = array("", "");

                        $newphrase = str_replace($healthy, $yummy, $phrase);
                    }
                    if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                ?>
                <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                  <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="Immersion"/>
                <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                  <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="Immersion"/>
                <?php } ?>
                <span class="title-cta"><?php echo get_field('download_title'); ?></span>
                <span><?php echo get_field('download_cta'); ?></span>
                <a href="<?php echo get_field('download_link'); ?>" target="_blank"><?php echo get_field('download_button'); ?></a>
            </div>
        
        
        </div>
    
    </div>

</section>
<?php*/?>

<section class="technology-experience container-padding" id="<?php echo get_field('id3'); ?>">
    <div class="img-wrap-bg">
        <?php 
            $side_image3 = explode("{:}", get_field('haptic_tool_image', get_the_ID(), false));
            $langs = $side_image3;

            foreach ($langs as $lang) {
                $phrase  = $side_image3;
                $healthy = array("{:en}", "{:ja}");
                $yummy   = array("", "");

                $newphrase = str_replace($healthy, $yummy, $phrase);
            }
            if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
        ?>
        <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="Immersion"/>
        <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
          <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="Immersion"/>
        <?php } ?>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-lg-7 col-md-12">
                <h2 class="title-teal"><?php echo get_field('experience_title'); ?></h2>
                <p><?php echo get_field('experience_content'); ?></p>
                <?php if( have_rows('lists') ): ?>
                <?php while( have_rows('lists') ): the_row(); ?>
                <div class="experience-list row">
                    <div class="col-lg-3 col-md-3">
                        <h3 class="title-black"><?php echo get_sub_field('title');?></h3>
                    </div>
                    <div class="col-lg-9 col-md-9">
                        <ul class="custom-list">
                            <?php if( have_rows('list') ): ?>
                            <?php while( have_rows('list') ): the_row(); ?>
                            <li><?php echo get_sub_field('description'); ?></li>
                            <?php endwhile; ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <?php endwhile; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>


<section class="technology-market container-padding" id="<?php echo get_field('id-marketsolutions'); ?>"
style="background-image: url(<?php echo get_field('market_solutions_background'); ?>);">
    <div class="container">
        <div class="row">
            <div class="col-lg-5 col-md-6 col-sm-12 market-content-left">
                <h2 class="title-teal"><?php echo get_field('market_solutions_title'); ?></h2>
                <div class="market-sensing-content">
                    <?php echo get_field('market_solutions_content'); ?>
                </div>
                <a class="arrow-link" href="<?php echo get_field('market_solutions_link'); ?>"><?php echo get_field('market_solutions_link_text'); ?></a>
            </div>
            <div class="col-lg-7 col-md-6 col-sm-12 market-content-right">
            </div>
        </div>
    </div>
</section>


<section class="technology-services container-padding" id="<?php echo get_field('id4'); ?>">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-md-12 col-sm-12">
                <div class="photo-wrapper">
                    <?php 
                        $side_image4 = explode("{:}", get_field('services_image', get_the_ID(), false));
                        $langs = $side_image4;

                        foreach ($langs as $lang) {
                            $phrase  = $side_image4;
                            $healthy = array("{:en}", "{:ja}");
                            $yummy   = array("", "");

                            $newphrase = str_replace($healthy, $yummy, $phrase);
                        }
                        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                    ?>
                    <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="Immersion"/>
                    <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="Immersion"/>
                    <?php } ?>
                </div>
            </div>
            <div class="col-lg-6 col-md-12 col-sm-12">
                <div class="row">
                    <div class="col"><h2 class="title-teal"><?php echo get_field('services_title'); ?></h2></div>
                </div>
                <?php if( have_rows('services') ): ?>
                <div class="services-list row">
                    <?php while( have_rows('services') ): the_row(); ?>
                    <div class="col-lg-g col-md-6 col-sm-12">
                        <h3 class="title-black"><?php echo get_sub_field('title'); ?></h3>
                        <?php echo get_sub_field('description'); ?>
                    </div>
                    <?php endwhile; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php 
    $side_image5 = explode("{:}", get_field('licensing_background', get_the_ID(),false));
    $langs = $side_image5;

    foreach ($langs as $lang) {
        $phrase  = $side_image5;
        $healthy = array("{:en}", "{:ja}");
        $yummy   = array("", "");

        $newphrase = str_replace($healthy, $yummy, $phrase);
    }
    if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
?>
<?php if ( WPGlobus::Config()->language == 'ja' ) { 
  $bg = wp_get_attachment_url( ($newphrase[$num]) );
} else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { 
  $bg = wp_get_attachment_url( ($newphrase[0]) );
} ?>
<section class="technology-licensing container-padding" id="<?php echo get_field('id5'); ?>" style="background-image: url('<?php echo $bg; ?>')">
    <div class="container">
        <div class="row">
            <div class="col">
                <h2 class="title-teal"><?php echo get_field('licensing_title'); ?></h2>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8">
                <?php echo get_field('licensing_description'); ?>
            </div>
            <div class="col-lg-4">
                <a href="<?php echo get_field('portfolio_link'); ?>" class="button-cta"><span><?php echo get_field('portfolio_cta'); ?></span></a>
            </div>
        </div>
    </div>
</section>

<?php echo get_template_part('parts/part', 'innovation'); ?>
<?php echo get_template_part('parts/part', 'cta'); ?>
<?php get_footer('custom'); ?>