<?php
/*
Template Name: Blog Gaming
*/

get_header('custom'); 

// Define custom query parameters
$custom_query_args = array( 
    'cat' => '1',
    'post_type' => 'post'
);

// Get current page and append to custom query parameters array
$custom_query_args['paged'] = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;

// Instantiate custom query
$custom_query = new WP_Query( $custom_query_args );

// Pagination fix
$temp_query = $wp_query;
$wp_query   = NULL;
$wp_query   = $custom_query;

// Output custom query loop
if ( $custom_query->have_posts() ) : $postcount=0;
    while ( $custom_query->have_posts() ) :
        $custom_query->the_post();
?>
    <?php if($postcount==0) : ?>
        <?php if($paged==0) : ?>
        <section class="container-padding top-section blog-top-section" style="background-color: #e9e9e9;">
            <div class="container">
                <div class="post-container row">
                    <?php if(has_post_thumbnail()) { ?>
                    <div class="image-container col-lg-6 col-md-12 col-sm-12 col-xs-12" style="background-image:url(<?php the_post_thumbnail_url('large-size'); ?>)">
                    </div>
                    <?php } ?>
                    <div class="text-container <?php if(has_post_thumbnail()){echo 'col-lg-6 col-md-12 col-sm-12 col-xs-12';}else{echo 'col-lg-12 col-md-12';} ?>">
                        <span>Latest Post</span>
                        <h1><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h1>
                        <?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=400&length_type=characters&ellipsis=%26hellip;&exclude_tags=img,p,strong,a,h1,h2,h3,h4,h5,h6'); }  ?>
                    </div>
                </div>
            </div>
        </section>
        <?php endif; ?>
    <?php endif;  ?>

<?php $postcount++; endwhile; endif;
// Reset postdata
wp_reset_postdata(); ?>


<section class="blog-archive container-padding top-section">
            <div class="container">
                <div class="row">
                    <div class="col-lg-9 col-md-12 col-sm-12 col-xs-12">

<?php 
// Output custom query loop
if ( $custom_query->have_posts() ) : $postcount2=0;
    while ( $custom_query->have_posts() ) :
        $custom_query->the_post();
?>
                        
                        
        <?php if($postcount2==0 && $paged==0) : ?>
                        
        
                        
        <?php else: ?>
        <!-- Article Layout -->
        <article <?php post_class('row'); ?>>
            <div class="image-container col-lg-4 col-md-4 col-sm-5 col-xs-12" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');">
            <a href="<?php echo the_permalink(); ?>"></a></div>
            <div class="text-container col-lg-8 col-md-8 col-sm-7 col-xs-12">
                <div class="row">
                    <span class="date col-lg-6 col-md-12"><?php echo get_the_date(); ?></span>
                    <span class="categories col-lg-6 col-md-12"><?php echo the_category(); ?></span>
                </div>
                <h2 class="black-title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h2>
                <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=230&length_type=characters&ellipsis=%26hellip;&exclude_tags=img,p,strong,a,h1,h2,h3,h4,h5,h6'); }  ?></div>
                <div class="read-more"><a class="arrow-link" href="<?php echo the_permalink(); ?>">Read More</a></div>
            </div>
        </article>

        <!-- End of Article Layout -->      
                        
        <?php endif; ?>
                                
        
                                   
                            
                        
     <?php $postcount2++; endwhile; ?>
<?php endif;
// Reset postdata
wp_reset_postdata(); ?>   

                       

            <div class="row">
                <div class="col">
                <?php the_posts_pagination(array('screen_reader_text' => ' ')); ?>
                </div>
            </div>
            </div>
            <div class="col-lg-3 col-md-12 col-sm-12 col-xs-12 blog-sidebar">
                <?php dynamic_sidebar( 'blog_sidebar' ); ?>
            </div>
        </div>
        
    </div>
</section>



<?php
// Custom query loop pagination
// previous_posts_link( 'Older Posts' );
// next_posts_link( 'Newer Posts', $custom_query->max_num_pages );


// Reset main query object
$wp_query = NULL;
$wp_query = $temp_query;

?>
                
<?php get_footer('custom'); ?>
