﻿/*
** =======================================================================
** Copyright (c) 2016  Immersion Corporation.  All rights reserved.
**                     Immersion Corporation Confidential and Proprietary.
**
** =======================================================================
*/

using UnityEngine;
using System.Collections.Generic;
using System;
using UnityEngine.UI;

public class Logger {
    private Text mText;
    private List<string> mLog;
    private string mLinePrefix = ">> ";

    public Logger (Text text) {
        mText = text;
        mLog = new List<string>();
    }

    public void Print(string line) {
        PrintToLog(line, false);
    }

    public void PrintError(string line) {
        PrintToLog(line, true);
    }

    private void PrintToLog(string line, bool isError) {
        mLog.Insert(0, mLinePrefix + line);

        mText.text = String.Join(Environment.NewLine, mLog.ToArray());
        if (isError) {
            Debug.LogError(line);
        } else {
            Debug.Log(line);
        }
    }
}
