/*
** =======================================================================
**   Copyright (c) 2016-2017  Immersion Corporation.  All rights reserved.
**                     Immersion Corporation Confidential and Proprietary.
**
** =======================================================================
*/

#include <jni.h>
#include <unistd.h>
#include "TouchSenseSDK.h"
#include "c_tssdk_error_codes.h"
#include "c_tssdk_info_codes.h"

// TODO: You need to pass in the credentials provided to you by Immersion.
// It is recommended that you don't hard-code the credentials.
// You should store them on the cloud, then fetch them, and pass them in at runtime.
// Also, use the preferred DNS URL if it was provided to you by Immersion, otherwise use null.
// Note that Haptics will not work with invalid credentials!
const char* USERNAME = NULL;
const char* PASSWORD = NULL;
const char* DNS      = NULL;

static JavaVM *g_javavm = 0;

jint JNI_OnLoad(JavaVM* vm, void* reserved)
{
    g_javavm = vm;
    return JNI_VERSION_1_6;
}

enum ErrorCodes {
    PLAY_HAPTICS_SUCCESS = 0,
    FAILED_TO_CREATE = 1,
    FAILED_DUE_TO_BAD_PARAMETERS = 2,
    FAILED_DUE_TO_MISSING_PERMISSIONS = 3,
    FAILED_DUE_TO_INVALID_CREDENTIALS = 4,
    FAILED_TO_ADD_RESOURCE = 5,
    FAILED_TO_PLAY = 6,
    FAILED_TO_STOP = 7,
    FAILED_TO_REMOVE_RESOURCE = 8,
    FAILED_TO_DISPOSE = 9,
};

#define DISPOSE_AND_RETURN(val) touchsensesdk_dispose(player); return val;

JNIEXPORT jint JNICALL
Java_com_immersion_nativesampleapp_MainActivity_playHaptics(JNIEnv *env, jobject instance, jobject context, jstring haptUri) {
    void* player = touchsensesdk_create(g_javavm, &context, USERNAME, PASSWORD, DNS);
    if (player == NULL) {
        return FAILED_TO_CREATE;
    }

    int playerState = touchsensesdk_getPlayerInfo(player, TSSDK_PLAYER_STATE);
    switch (playerState) {
        case TSSDK_BAD_PARAMETER:
            DISPOSE_AND_RETURN(FAILED_DUE_TO_BAD_PARAMETERS);
        case TSSDK_MISSING_PERMISSIONS:
            DISPOSE_AND_RETURN(FAILED_DUE_TO_MISSING_PERMISSIONS);
        case TSSDK_INVALID_CREDENTIALS:
            DISPOSE_AND_RETURN(FAILED_DUE_TO_INVALID_CREDENTIALS);
    }

    const char* uri = (*env)->GetStringUTFChars(env, haptUri, NULL);
    int rid = touchsensesdk_addResource(player, uri, TSSDK_ASYNC_HAPTIC_EFFECT);
    (*env)->ReleaseStringUTFChars(env, haptUri, uri);
    if (rid <= 0) {
        DISPOSE_AND_RETURN(FAILED_TO_ADD_RESOURCE);
    }

    int eid = touchsensesdk_play(player, rid, TSSDK_NORMAL);
    if (eid <= 0) {
        DISPOSE_AND_RETURN(FAILED_TO_PLAY);
    }

    sleep(1);

    int res = touchsensesdk_stop(player, eid);
    if (res != TSSDK_SUCCESS) {
        DISPOSE_AND_RETURN(FAILED_TO_STOP);
    }

    res = touchsensesdk_removeResource(player, rid);
    if (res != TSSDK_SUCCESS) {
        DISPOSE_AND_RETURN(FAILED_TO_REMOVE_RESOURCE);
    }

    res = touchsensesdk_dispose(player);
    if (res != TSSDK_SUCCESS) {
        return FAILED_TO_DISPOSE;
    }

    return PLAY_HAPTICS_SUCCESS;
}
