/*
** =======================================================================
** Copyright (c) 2016 Immersion Corporation.  All rights reserved.
**                    Immersion Corporation Confidential and Proprietary.
**
** =======================================================================
*/

/*!
 * \file c_tssdk_info_codes.h
 * Info Codes
 * This class exposes all the info code numbers needed to query information
 * about the SDK, haptic resources and effects.
 */

#ifndef __C_TSSDK_INFO_CODES_H__
#define __C_TSSDK_INFO_CODES_H__

    /// The different states of the HapticMediaPlayer
    typedef enum {
        TSSDK_INITIALIZED             = 0,   /// Initialization succeeded, HapticMediaPlayer is ready to use
        TSSDK_BAD_PARAMETER           = 1,   /// Initialization failed, an incorrect parameter was specified
        TSSDK_MISSING_PERMISSIONS     = 2,   /// Initialization failed, missing manifest permission declarations
        TSSDK_INVALID_CREDENTIALS     = 3    /// Initialization failed, invalid credentials
    } TSSDK_PlayerState;

    /// The different states of the HapticResource
    typedef enum {
        TSSDK_NOT_READY       = 10,    /// The initial state of a HapticResource
        TSSDK_INVALID         = 11,    /// The Haptic Resource is invalid
        TSSDK_READY           = 12,    /// The Haptic Resource is verified and is ready to be played
        TSSDK_DOWNLOAD_ERROR  = 13     /// The Haptic Resource failed to download the file
    } TSSDK_ResourceState;

    /// The different states of the HapticEffect
    typedef enum {
        TSSDK_IDLE            = 20,    /// The initial state of a HapticEffect (temporary state)
        TSSDK_PLAYING         = 21,    /// The Haptic Effect is currently playing
        TSSDK_PAUSED          = 22,    /// The Haptic Effect is currently paused
        TSSDK_BUFFERING       = 23,    /// The Haptic Effect is paused due to buffering
        TSSDK_TIMEOUT         = 24     /// The Haptic Effect is paused due to a timeout
    } TSSDK_EffectState;

    /// The different muted states of the HapticEffect
    typedef enum {
        TSSDK_MUTED           = 30,     /// The Haptic Effect is muted
        TSSDK_NOT_MUTED       = 31      /// The Haptic Effect is not muted
    } TSSDK_EffectMutedState;

    /// Types of HapticResource to be used when calling {@link HapticMediaPlayer::addResource}
    typedef enum  {
        TSSDK_ASYNC_HAPTIC_EFFECT = 1,    //!< Asynchronous haptic effect
        TSSDK_SYNC_HAPTIC_EFFECT  = 2     //!< Synchronizable haptic effect
    } TSSDK_HapticEffectType;

    /// HapticResource locations
    typedef enum  {
        TSSDK_LOCAL_HAPTIC_EFFECT  = 1,    //!< Local haptic effect
        TSSDK_REMOTE_HAPTIC_EFFECT = 2     //!< Remote haptic effect
    } TSSDK_HapticEffectLocation;

    /// HapticEffect playback priorities to be used when calling {@link HapticMediaPlayer::play}
    typedef enum {
        TSSDK_LOWEST  = 0,
        TSSDK_LOW     = 1,
        TSSDK_NORMAL  = 2,
        TSSDK_HIGH    = 3,
        TSSDK_HIGHEST = 4,
        TSSDK_NUM_OF_PRIORITIES
    } TSSDK_EffectPriority;

    /// Types of information that can be retrieved from calling {@link HapticMediaPlayer::getPlayerInfo}
    typedef enum {
        TSSDK_PLAYER_STATE                = 40,     /// State of HapticMediaPlayer
        TSSDK_PLAYER_VERSION_MAJOR        = 41,     /// Major version of the HapticMediaPlayer
        TSSDK_PLAYER_VERSION_MINOR        = 42,     /// Minor version of the HapticMediaPlayer
        TSSDK_PLAYER_VERSION_BUILD        = 43,     /// Build version of the HapticMediaPlayer
        TSSDK_PLAYER_VERSION_MAINTENANCE  = 44,     /// Maintenance version of the HapticMediaPlayer
        TSSDK_PLAYER_VERSION_PATCH        = 45,     /// Patch version number of the HapticMediaPlayer
        TSSDK_PLAYER_PLAYBACK_TYPE        = 46      /// Type of playback (None, Android Vibrate API or TouchSense)
    } TSSDK_PlayerInfo;

    /// Types of information that can be retrieved from calling {@link HapticMediaPlayer::getEffectInfo}
    typedef enum {
        TSSDK_RESOURCE_STATE     = 50,  /// State of a HapticResource
        TSSDK_EFFECT_STATE       = 51,  /// State of a HapticEffect
        TSSDK_EFFECT_MUTED_STATE = 52,  /// Muted state of a HapticEffect
        TSSDK_RESOURCE_TYPE      = 53,  /// Sync or async HapticResource {@link TSSDK_HapticEffectType}
        TSSDK_RESOURCE_LOCATION  = 54,  /// Local or remote HapticResource  {@link TSSDK_HapticEffectLocation}
        TSSDK_RESOURCE_DURATION  = 55   /// Length in milliseconds of HapticResource
    } TSSDK_EffectInfo;

    /// Types of playback
    typedef enum {
        TSSDK_NO_PLAYBACK = 0,                    /// No playback
        TSSDK_ANDROID_VIBRATE_API_PLAYBACK = 1,   /// Playback using Android Vibrate API
        TSSDK_TOUCHSENSE_PLAYBACK = 2             /// Playback using TouchSense
    } TSSDK_PlaybackType;

#endif // __C_TSSDK_INFO_CODES_H__