/** =======================================================================
 **   Copyright (c) 2016-2017  Immersion Corporation.  All rights reserved.
 **                     Immersion Corporation Confidential and Proprietary.
 **
 ** =======================================================================
 */

package com.immersion.nativesampleapp;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class MainActivity extends Activity {
    static final int PLAY_HAPTICS_SUCCESS = 0;
    static final int FAILED_TO_CREATE = 1;
    static final int FAILED_DUE_TO_BAD_PARAMETERS = 2;
    static final int FAILED_DUE_TO_MISSING_PERMISSIONS = 3;
    static final int FAILED_DUE_TO_INVALID_CREDENTIALS = 4;
    static final int FAILED_TO_ADD_RESOURCE = 5;
    static final int FAILED_TO_PLAY = 6;
    static final int FAILED_TO_STOP = 7;
    static final int FAILED_TO_REMOVE_RESOURCE = 8;
    static final int FAILED_TO_DISPOSE = 9;

    static {
        ///////////////////////////////////////////////////////////////////////////////////
        // In case of running on old Android versions (e.g. 4.1.1, 4.2.2)
        // and getting the following UnsatisfiedLinkError exception:
        //      could not load library "libTouchSenseSDK.so" needed by "libnative-sample-app.so"
        // Uncomment the following line:
        // System.loadLibrary("TouchSenseSDK");
        ///////////////////////////////////////////////////////////////////////////////////
        System.loadLibrary("native-sample-app");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        final ArrayList<String> haptUri = initEffectsFromRawRes();

        findViewById(R.id.btn_effect1).setOnClickListener(
            new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    startEffectPlayback(haptUri.get(0));
                }
            }
        );

        findViewById(R.id.btn_effect2).setOnClickListener(
                new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        startEffectPlayback(haptUri.get(1));
                    }
                }
        );

        findViewById(R.id.btn_effect3).setOnClickListener(
                new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        startEffectPlayback(haptUri.get(2));
                    }
                }
        );

        findViewById(R.id.btn_effect4).setOnClickListener(
                new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        startEffectPlayback(haptUri.get(3));
                    }
                }
        );
    }

    private void startEffectPlayback(String uri){
        int res = playHaptics(getApplicationContext(), uri);
        if (res != PLAY_HAPTICS_SUCCESS) {
            Toast.makeText(getApplicationContext(),
                    "ERROR: " + getErrorMessage(res), Toast.LENGTH_LONG).show();
        }
    }

    private ArrayList<String> initEffectsFromRawRes(){
        Field[] fields = R.raw.class.getFields();
        ArrayList<String> hapticpath = new ArrayList<String>();
        int rid;
        //loop through files in raw folder
        for (int i = 0; i < fields.length; i++){
            try {
                if (fields[i].isSynthetic()){
                    continue;
                }
                rid = fields[i].getInt(fields[i]);
            } catch (Exception e) {
                continue;
            }
            String filename = fields[i].getName();
            hapticpath.add(copyHaptToInternalStorage(rid, filename));
        }
        return hapticpath;
    }

    private String copyHaptToInternalStorage(int id, String haptFileName) {
        FileOutputStream fos = null;
        InputStream is = null;
        int maxLen = 1024, curLen = 0;
        byte[] tempBuffer = new byte[maxLen];
        try {
            is = getResources().openRawResource(id);
            fos = openFileOutput(haptFileName, Context.MODE_PRIVATE);
            curLen = is.available();
            while (curLen > 0)
            {
                curLen = is.read(tempBuffer);
                fos.write(tempBuffer, 0, curLen);
                curLen = is.available();
            }
        } catch (FileNotFoundException fnfe) {
        } catch (IOException ioe) {
        } finally {
            closeStream(fos);
            closeStream(is);
        }

        // Retrieve the path of the hapt file now on disk
        File file = getFilesDir();
        String path = file.getAbsolutePath() + File.separator + haptFileName;
        return path;
    }

    private void closeStream(Closeable c) {
        if (c != null) {
            try {
                c.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getErrorMessage(int errorCode) {
        switch (errorCode) {
            case FAILED_TO_CREATE:
                return "FAILED_TO_CREATE";
            case FAILED_DUE_TO_BAD_PARAMETERS:
                return "FAILED_DUE_TO_BAD_PARAMETERS";
            case FAILED_DUE_TO_MISSING_PERMISSIONS:
                return "FAILED_DUE_TO_MISSING_PERMISSIONS";
            case FAILED_DUE_TO_INVALID_CREDENTIALS:
                return "FAILED_DUE_TO_INVALID_CREDENTIALS";
            case FAILED_TO_ADD_RESOURCE:
                return "FAILED_TO_ADD_RESOURCE";
            case FAILED_TO_PLAY:
                return "FAILED_TO_PLAY";
            case FAILED_TO_STOP:
                return "FAILED_TO_STOP";
            case FAILED_TO_REMOVE_RESOURCE:
                return "FAILED_TO_REMOVE_RESOURCE";
            case FAILED_TO_DISPOSE:
                return "FAILED_TO_DISPOSE";
            default:
                return "Unknown Error";
        }
    }

    private native int playHaptics(Context context, String haptUri);
}
