/*
** ============================================================================
** Copyright (c) 2016-2017  Immersion Corporation.  All rights reserved.
**                          Immersion Corporation Confidential and Proprietary.
**
** ============================================================================
*/

/*!
 * \file c_tssdk_error_codes.h
 * Error Codes
 * This class exposes all the error codes that are returned by TouchSenseSDK
 * API invocations.
 */

#ifndef __C_TSSDK_ERROR_CODES_H__
#define __C_TSSDK_ERROR_CODES_H__

typedef enum {
    TSSDK_SUCCESS                     = 0,   /// SUCCESSFUL OPERATION
    TSSDK_INVALID_PARAMETER           = -1,  /// INVALID PARAMETER PASSED
    TSSDK_INVALID_URI                 = -2,  /// INVALID URI PASSED
    TSSDK_INVALID_EFFECT              = -3,  /// INVALID EFFECT
    TSSDK_OUT_OF_MEMORY               = -5,  /// RAN OUT OF MEMORY
    TSSDK_IO_ERROR                    = -7,  /// ERROR WHILE READING/WRITING FILE
    TSSDK_HAPT_NOT_READY              = -9,  /// HAPT FILE IS NOT READY FOR PLAYBACK
    TSSDK_TOO_MANY_EFFECTS            = -10, /// TOO MANY HAPTIC RESOURCES WERE ALREADY LOADED
    TSSDK_PLAYER_NOT_INITIALIZED      = -11, /// PLAYER NOT INITIALIZED
    TSSDK_TOO_MANY_CONCURRENT_EFFECTS = -12, /// TOO MANY EFFECTS PLAYING AT THE SAME TIME
    TSSDK_INVALID_STATE               = -13, /// INVALID STATE
    TSSDK_LIB_VERSION_NOT_FOUND       = -14, /// HAPTIC MEDIA PLAYER VERSION NOT FOUND
    TSSDK_SDK_INOPERATIVE             = -15  /// TS SDK SUFFERED A FATAL ERROR AND IS NOW INOPERATIVE
} TSSDK_Error;

#endif // __C_TSSDK_ERROR_CODES_H__