<?php
/*
	Template Name: Resources
*/

get_header('custom'); ?>

<section class="studies-research container-padding top-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 offset-lg-2">
                <h1 class="page-title"><?php echo get_field('info_title'); ?></h1>
                <?php echo get_field('info_description'); ?>
            </div>
            
        </div>
    </div>
</section>

<section class="studies-links container-padding">
    <div class="container">
        <div class="row">
            <div class="col"><h2><?php echo get_field('resources_title'); ?></h2></div>
        </div>
        <div class="row">
            <?php if( have_rows('resources') ): ?>
            <?php while( have_rows('resources') ): the_row();?>
            <div class="resource-container col-lg-4 col-md-6 col-sm-6 col-xs-12">
                <a href="<?php echo get_sub_field('link'); ?>" target="_blank" class="resource-link">
                    <?php 
                        $side_image = explode("{:}", get_sub_field('image', false));
                        $langs = $side_image;

                        foreach ($langs as $lang) {
                            $phrase  = $side_image;
                            $healthy = array("{:en}", "{:ja}");
                            $yummy   = array("", "");

                            $newphrase = str_replace($healthy, $yummy, $phrase);
                        }
                        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                    ?>
                    <?php if ( WPGlobus::Config()->language == 'ja' ) { 
                      $bg = wp_get_attachment_url( ($newphrase[$num]) );
                    } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { 
                      $bg = wp_get_attachment_url( ($newphrase[0]) );
                    } ?>
                    <div class="image-container" style="background-image: url('<?php echo $bg; ?>');">
                        <div class="hover">
                            <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/pdf.png">
                            <span>Download PDF</span>
                        </div>
                    </div>
                    <div class="title-container"><span><?php echo get_sub_field('title'); ?></span></div>
                </a>
            </div>
            <?php endwhile; ?>
            <?php endif; ?>	
        </div>
    </div>
</section>


<?php echo get_template_part('parts/part', 'cta'); ?>
<?php get_footer('custom'); ?>