<?php
/*
	Template Name: Latest News 
*/

get_header('custom'); ?>


<section class="news-title container-padding top-section" style="background-image:url('<?php echo get_field('section_background')['url']; ?>');">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h1><?php echo get_field('section_title'); ?></h1>
            </div>
        </div>
    </div>
</section>

<section class="news-blog container-padding">
    <div class="container">
        <div class="row">
            <div class="col">
                <h2 class="title-teal text-center"><?php echo get_field('news_feed_title');?></h2>
            </div>
        </div>
        <div class="row news-wrap">
            <?php                 
            $initiallist = new WP_Query(array(
                'orderby'           => 'date', 
                'posts_per_page'    => 3,
                'post_type'         => array('news'),
            )); 
            
            if($initiallist->have_posts()): while($initiallist->have_posts()) : $initiallist->the_post();

            ?>
            <div class="col-lg-4 col-md-4 col-xs-4 col-sm-12">
                <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');"><a href="<?php if(get_sub_field('alternative_link')){echo get_sub_field('alternative_link'); }else{ echo the_permalink(); } ?>"></a></div>
                <div class="text-container">
                    <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                    <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=70&length_type=characters&ellipsis=%26hellip;&exclude_tags=img,p,strong,a,h1,h2,h3,h4,h5,h6'); }  ?></div>
                </div>
            </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>	
            <div class="col-lg-12"><div class="read-more text-right"><a class="arrow-link text-center" href="<?php echo get_field('news_feed_link');?>"><?php echo get_field('news_feed_button');?></a></div></div>
        </div>
        <div class="row">
            <div class="col">
                <h2 class="title-teal text-center"><?php echo get_field('blog_section_title');?></h2>
            </div>
        </div>
        <div class="row news-wrap">
            <?php                 
            $initiallist = new WP_Query(array(
                'orderby'           => 'date', 
                'posts_per_page'    => 3,
            )); 
            
            if($initiallist->have_posts()): while($initiallist->have_posts()) : $initiallist->the_post();

            ?>
            <div class="col-lg-4 col-md-4 col-xs-4 col-sm-12">
                <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');"><a href="<?php if(get_sub_field('alternative_link')){echo get_sub_field('alternative_link'); }else{ echo the_permalink(); } ?>"></a></div>
                <div class="text-container">
                    <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                    <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=70&length_type=characters&ellipsis=%26hellip;&exclude_tags=img,p,strong,a,h1,h2,h3,h4,h5,h6'); }  ?></div>
                </div>
            </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>		
            <div class="col-lg-12"><div class="read-more text-right"><a class="arrow-link text-center" href="<?php echo get_field('blog_section_link');?>"><?php echo get_field('blog_section_button');?></a></div></div>
        </div>
    </div>
</section>

<section class="press-releases container-padding">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h2 class="title-teal"><?php echo get_field('press_title');?></h2>
            </div>
        </div>
        <div class="row">
            <?php
			$xmlstr = get_xml_from_url('https://ir.immersion.com/rss/news-releases.xml');
    		$rss_xml = new SimpleXMLElement($xmlstr);

			if (!empty($rss_xml)) {

				$news_items = 2; // how many news items to show
				$x = 0;

				while ($x < $news_items) {

					$news_title = (string) $rss_xml->channel->item[$x]->title;
					$news_date = (string) date('M j, Y', strtotime($rss_xml->channel->item[$x]->pubDate));
					$news_link = (string) $rss_xml->channel->item[$x]->link;

					echo '<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6"><div class="text-container">';
                    echo '<span class="date">'.$news_date.'</span>';
					echo '<h3 class="title"><a href="'.$news_link.'" target="_blank">'.$news_title.'</a><h3>';
					echo '</div></div>';

					++$x;
				}
			} ?> 
            
            <div class="col-lg-12"><div class="read-more text-right"><a class="arrow-link text-center" href="<?php echo get_field('press_link');?>"><?php echo get_field('press_button');?></a></div></div>
        </div>
    </div>
</section>

<section class="news-events container-padding">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h2 class="title-teal"><?php echo get_field('events_title');?></h2>
            </div>
        </div>
        <div class="row">
            
            <div class="col-lg-4 col-md-4 col-sm-12">
            <?php                 
            $initiallist = new WP_Query(array(
                'orderby'           => 'date', 
                'posts_per_page'    => 1,
                'post_type'         => array('events'),
            )); 
            
            if($initiallist->have_posts()): while($initiallist->have_posts()) : $initiallist->the_post();

            ?>
                <div class="text-container">
                    <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                    <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=410&length_type=characters&ellipsis=%26hellip;&exclude_tags=img,p,strong,a,h1,h2,h3,h4,h5,h6'); }  ?></div>
                    <div class="dates"><?php echo get_field('event_schedule'); ?></div>
                </div>
            <?php endwhile; wp_reset_postdata(); endif; ?>		
            </div>
            
            
            
            <div class="col-lg-8 col-md-8 col-sm-12">
                <div class="row">
            <?php                 
                    
            $initiallist = new WP_Query(array(
                'orderby'           => 'date', 
                'posts_per_page'    => 4,
                'post_type'         => array('events'),
                'offset'            => 1
            )); 
            
            if($initiallist->have_posts()): while($initiallist->have_posts()) : $initiallist->the_post();

            ?>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12 latest-articles">
                    <div class="text-container">
                        <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                        <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=230&length_type=characters&ellipsis=%26hellip;&exclude_tags=img,p,strong,a,h1,h2,h3,h4,h5,h6'); }  ?></div>
                        <div class="dates"><?php echo get_field('event_schedule'); ?></div>
                    </div>
                </div>
            
            <?php endwhile; wp_reset_postdata(); endif; ?>		
                </div>
            </div>
            
            
            <div class="col-lg-12"><div class="read-more text-right"><a class="arrow-link text-center" href="<?php echo get_field('events_link');?>"><?php echo get_field('events_button'); ?></a></div></div>
        </div>
    </div>
</section>


<?php get_footer('custom'); ?>