<?php
/*
	Template Name: Home
*/

get_header('custom'); ?>

<?php get_template_part('parts/part', 'homebanner'); ?>

<section class="home-about">
    <div class="container">
        <div class="row">
            <div class="col-md-6 col-xs-12 world-touch container-padding">
                <h2 class="title-teal"><?php echo get_field('about_title'); ?></h2>
                <div class="info"><?php echo get_field('about_content'); ?></div>
                <div class="container">
                    <?php if( have_rows('statistics') ): ?>
                    <div class="numbers row">
                        <?php while( have_rows('statistics') ): the_row(); ?>
                        <div class="number col">
                            <div class="number-item"><?php echo get_sub_field('number'); ?></div>
                            <span class="desc"><?php echo get_sub_field('description'); ?></span>
                        </div>	
                        <?php endwhile; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-6 col-xs-12 circle-animation">
                <div class="circles-wrap">
                    <img src="<?php echo get_stylesheet_directory_uri() ?>/images/outer-extra-circle.png" alt="" class="circle-extra-outer">
                    <img src="<?php echo get_stylesheet_directory_uri() ?>/images/outer-circle.png" alt="" class="circle-outer">
                    <div class="img-wrap">
                        <?php 
                            $side_image0 = explode("{:}", get_field('about_image', get_the_ID(), false));
                            $langs = $side_image0;

                            foreach ($langs as $lang) {
                                $phrase  = $side_image0;
                                $healthy = array("{:en}", "{:ja}", "{:zh}");
                                $yummy   = array("", "");
                                $newphrase = str_replace($healthy, $yummy, $phrase);
                            }
                            if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                        ?>
                        <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="devices-img"/>
                        <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="devices-img"/>
                        <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="devices-img"/>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="home-news container-padding">
    <div class="container">
        <div class="row">
            <?php if( have_rows('announcements') ): ?>
            <?php while( have_rows('announcements') ): the_row();?>
            <?php 
                $side_image = explode("{:}", get_sub_field('background_image', false));
                $langs = $side_image;

                foreach ($langs as $lang) {
                    $phrase  = $side_image;
                    $healthy = array("{:en}", "{:ja}",  "{:zh}");
                    $yummy   = array("", "");
                    $newphrase = str_replace($healthy, $yummy, $phrase);
                }
                if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
            ?>
            <?php if ( WPGlobus::Config()->language == 'ja' ) { 
              $bg = wp_get_attachment_url( ($newphrase[$num]) );
            } else if ( WPGlobus::Config()->language == 'zh' ) { 
                $bg = wp_get_attachment_url( ($newphrase[$num]) );
            } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { 
              $bg = wp_get_attachment_url( ($newphrase[0]) );
            } ?>
            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                <div class="news-box" style="background-image: url('<?php echo $bg; ?>');">
                    <a href="<?php echo get_sub_field('link'); ?>" target="_blank">
                        <div class="text-wrap">
                            <span class="title"><?php echo get_sub_field('title'); ?></span>
                            <span class="button button-fill learn-more button-cta"><span><?php echo get_sub_field('button_text'); ?></span></span>
                        </div>
                    </a>
                </div>
            </div>
            
            <?php endwhile; ?>
            <?php endif; ?>		
        </div>
    </div>
</section>

<section class="home-technology container-padding">
    <div class="container"> 
        <div class="row">
            <div class="col-md-4 col-sm-12 col-xs-12 ">
                <h2 class="title-teal"><?php echo get_field('technology_title'); ?></h2>
            </div>
            <div class="col-md-8 col-sm-12 col-xs-12 ">
                <div class="desc">
                    <?php echo get_field('technology_content'); ?>
                </div>
            </div>
        </div>
        <div class="row links-wrap button-animation">
            <?php if( have_rows('solutions') ): ?>
            <?php while( have_rows('solutions') ): the_row();?>
            <div class="link-item col">
                <a href="<?php echo get_sub_field('link'); ?>" class="icon-link">
                    <div class="button-wrap">
                        <a href="<?php echo get_sub_field('link'); ?>" class="home-icon" >
                            <?php 
                                $side_image1 = explode("{:}", get_sub_field('icon', false));
                                $langs = $side_image1;

                                foreach ($langs as $lang) {
                                    $phrase  = $side_image1;
                                    $healthy = array("{:en}", "{:ja}", "{:zh}");
                                    $yummy   = array("", "");
                                    $newphrase = str_replace($healthy, $yummy, $phrase);
                                }
                                if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                            ?>
                            <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                              <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="icon"/>
                            <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                              <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="icon"/>
                            <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                              <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="icon"/>
                            <?php } ?>
                        </a>
                        <svg class="outer-circle-wrap" width="110" height="120" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="outer circle-outer-1" id="circle-outer-1" d="M59,5c30.38,0,56,24.62,56,55s-24.62,55-55,55S5,90.38,5,60S28.62,5,59,5z" fill-rule="nonzero" fill="#070707" />
                            <path class="outer blob-outer-1" id="blob-outer-1" d="M13.55,38.75C23.58,8.8,64.45,12.25,89.5,14.53c27.25,2.48,34.29,40.4,8.58,62.43c-18.64,15.98-35.86,41.94-59.19,28.38S-0.57,80.91,13.55,38.75z" fill-rule="nonzero" />
                        </svg>
                        <svg class="inner-circle-wrap" width="110" height="120" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="inner circle-inner-1" id="circle-inner-1" d="M59,15c24.85,0,46,20.15,46,45s-20.15,45-45,45S15,84.85,15,60S34.15,15,59,15z" fill-rule="nonzero" />
                            <path class="inner blob-inner-1" id="blob-inner-1" d="M10.27,59.49C30.64,39.13,25.28,6.97,58.51,11.26c26.42,3.41,33.22,14.83,42.88,39.66 c15.01,38.59-9.81,49.31-36.45,49.31S-8.57,78.33,10.27,59.49z" />
                        </svg>
                    </div>
                    <span class="title"><?php echo get_sub_field('line1'); ?><br><?php echo get_sub_field('line2'); ?></span>
                </a>
            </div>
            <?php endwhile; ?>
            <?php endif; ?>								
        </div>
    </div>
</section>

<section class="home-partners container-padding">
    <div class="container">
        <?php if( have_rows('partner__certified') ): 
        $count = 0; ?>
            <?php while( have_rows('partner__certified') ): the_row();?>
            
            <div class="row">
                <div class="table-row col <?php if($count == 1) { echo 'second-row'; }?>">
                    <?php 
                        $side_image2 = explode("{:}", get_sub_field('image', false));
                        $langs = $side_image2;

                        foreach ($langs as $lang) {
                            $phrase  = $side_image2;
                            $healthy = array("{:en}", "{:ja}", "{:zh}");
                            $yummy   = array("", "");
                            $newphrase = str_replace($healthy, $yummy, $phrase);
                        }
                        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                    ?>
                    <?php if ( WPGlobus::Config()->language == 'ja' ) { 
                      $bg = wp_get_attachment_url( ($newphrase[$num]) );
                    } else if ( WPGlobus::Config()->language == 'zh' ) { 
                      $bg = wp_get_attachment_url( ($newphrase[$num]) );
                    } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { 
                      $bg = wp_get_attachment_url( ($newphrase[0]) );
                    } ?>
                    
                    <?php if($count == 0) {?>
                    <div class="cell cell-img col-md-6 col-sm-12 col-xs-12" style="background-image:url('<?php echo $bg; ?>);'"></div>
                    <?php } ?>
                    <div class="cell cell-txt col-md-6 col-sm-12 col-xs-12 <?php if($count == 1) { echo 'second-row-content'; }?>">
                        <div class="wrap">
                            <h3 class="title-teal"><?php echo get_sub_field('title'); ?></h3>
                            <?php echo get_sub_field('content'); ?>
                            <p><a class="arrow-link" href="<?php echo get_sub_field('link_url'); ?>"><?php echo get_sub_field('link_text'); ?></a></p>
                        </div>
                    </div>
                    <?php if($count == 1) {?>
                    <div class="cell cell-img col-md-6 col-sm-12 col-xs-12 second-row-image" style="background-image:url('<?php echo $bg; ?>);'"></div>
                    <?php } ?>
                </div>
            </div>
            <?php $count++; endwhile; ?>
        <?php endif; ?>
    </div>
</section>

<?php echo get_template_part('parts/part', 'innovation'); ?>
<?php echo get_template_part('parts/part', 'panels'); ?>
<?php echo get_template_part('parts/part', 'cta'); ?>
<?php get_footer('custom'); ?>


<script type="text/javascript">
	
	jQuery(window).load(function($){
		jQuery('.digital-text').css({'opacity':'1'});
		//only for desktop
		if(jQuery('.mobile-uvp').css('display') == 'none'){
			var homeURL = '<?php echo get_site_url(); ?>';
			jQuery('.experience').css({'background': "url('" + homeURL + "/wp-content/themes/immersion/images/background-digital-experience.jpg') no-repeat center center transparent"}); 
		}
	});

</script>