<?php
/*
	Template Name: Use Cases
*/

get_header('custom'); ?>


<section class="usecase-header container-padding top-section">
    <div class="container">
        <div class="row">
            <h1 class="page-title"><?php echo get_field('info_title'); ?></h1>
            <?php echo get_field('info_description'); ?>
        </div>
    <div class="row links-wrap button-animation">
            <?php if( have_rows('navigation') ): ?>
            <?php while( have_rows('navigation') ): the_row();?>
            <div class="link-item col">
                <a href="#<?php echo get_sub_field('href'); ?>" title="<?php echo get_sub_field('line1'); ?>" class="icon-link scroll">
                    <div class="button-wrap">
                        <svg class="outer-circle-wrap" width="110" height="120" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="outer circle-outer-1" id="circle-outer-1" d="M59,5c30.38,0,56,24.62,56,55s-24.62,55-55,55S5,90.38,5,60S28.62,5,59,5z" fill-rule="nonzero" fill="#070707" />
                            <path class="outer blob-outer-1" id="blob-outer-1" d="M13.55,38.75C23.58,8.8,64.45,12.25,89.5,14.53c27.25,2.48,34.29,40.4,8.58,62.43 	c-18.64,15.98-35.86,41.94-59.19,28.38S-0.57,80.91,13.55,38.75z" fill-rule="nonzero" />
                        </svg>
                        <svg class="inner-circle-wrap" width="110" height="120" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="inner circle-inner-1" id="circle-inner-1" d="M59,15c24.85,0,46,20.15,46,45s-20.15,45-45,45S15,84.85,15,60S34.15,15,59,15z" fill-rule="nonzero" />
                            <path class="inner blob-inner-1" id="blob-inner-1" d="M10.27,59.49C30.64,39.13,25.28,6.97,58.51,11.26c26.42,3.41,33.22,14.83,42.88,39.66 c15.01,38.59-9.81,49.31-36.45,49.31S-8.57,78.33,10.27,59.49z" />
                        </svg>
                        <div class="button-touch">
                            <?php 
                                $side_image = explode("{:}", get_sub_field('icon', false));
                                $langs = $side_image;

                                foreach ($langs as $lang) {
                                    $phrase  = $side_image;
                                    $healthy = array("{:en}", "{:ja}");
                                    $yummy   = array("", "");

                                    $newphrase = str_replace($healthy, $yummy, $phrase);
                                }
                                if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                            ?>
                            <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                              <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="icon"/>
                            <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                              <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="icon"/>
                            <?php } ?>
                        </div>
                    </div>
                    <span class="title"><?php echo get_sub_field('line1'); ?></span>
                </a>
            </div>
            <?php endwhile; ?>
            <?php endif; ?>										
        </div>
    </div>
</section>

<?php if( have_rows('section') ):?>
<?php while( have_rows('section') ): the_row();?>
<section class="case-block" id="<?php echo get_sub_field('id'); ?>">
    
    
    <?php 
        $side_image2 = explode("{:}", get_sub_field('background',false));
        $langs = $side_image2;
    
        foreach ($langs as $lang) {
            $phrase  = $side_image2;
            $healthy = array("{:en}", "{:ja}");
            $yummy   = array("", "");
    
            $newphrase = str_replace($healthy, $yummy, $phrase);
        }
        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
    ?>
    <?php if ( WPGlobus::Config()->language == 'ja' ) { 
      $bg = wp_get_attachment_url( ($newphrase[$num]) );
    } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { 
      $bg = wp_get_attachment_url( ($newphrase[0]) );
    } ?>
    <div class="section-title" style="background-image:url('<?php echo get_sub_field('background')['url']; ?>');">
        <div class="icon-image">
            <div class="outer-circle">
                <div class="inner-circle">
                    <div class="icon">
                         <?php 
                            $side_image3 = explode("{:}", get_sub_field('icon', false));
                            $langs = $side_image3;

                            foreach ($langs as $lang) {
                                $phrase  = $side_image3;
                                $healthy = array("{:en}", "{:ja}");
                                $yummy   = array("", "");

                                $newphrase = str_replace($healthy, $yummy, $phrase);
                            }
                            if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                        ?>
                        <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="icon"/>
                        <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="icon"/>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <h2 class="title"><?php echo get_sub_field('title'); ?></h2>
    </div>
    <div class="section-slider">
        
        <div class="slider-container container">
                <div class="row">
                    
                    
                    <?php if( have_rows('featured_gallery') ): ?>
                    <?php while( have_rows('featured_gallery') ): the_row();?>
                    
                    <?php

                    $post_object = get_sub_field('featured', false);
                    $side_image4 = explode("{:}", get_sub_field('featured',false));
                    $langs = $side_image4;
                    
                    foreach ($langs as $lang) {
                        $phrase  = $side_image4;
                        $healthy = array("{:en}", "{:ja}");
                        $yummy   = array("", "");
                        
                        $newphrase = str_replace($healthy, $yummy, $phrase);
                    } 
                    if( $post_object ): 

                        // override $post
                        $post = $post_object;
                        setup_postdata( $post ); 

                        ?>
                     <?php
                            if ( WPGlobus::Config()->language == 'ja' ) {
                        ?>
                    <div class="swiper-slide col-lg-4 col-md-4 col-xs-4 col-sm-12">
                        <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail($newphrase[1])) { echo get_the_post_thumbnail_url($newphrase[1],'large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');">
                            <a href="<?php if(get_sub_field('use_case_alternative_link')){echo get_sub_field('use_case_alternative_link'); }else{ echo get_the_permalink($newphrase[1]); } ?>"></a>
                        </div>
                        <div class="text-container">
                            <h3 class="title"><a href="<?php echo get_the_permalink($newphrase[1]); ?>"><?php echo get_the_title($newphrase[1]); ?></a></h3>
                            <div class="excerpt"><?php if(has_excerpt($newphrase[1])) { echo get_the_excerpt($newphrase[1]); }else { echo ''; }  ?></div>
                        </div>
                    </div>
                    <?php
                    } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) {
                    ?> 
                    <div class="swiper-slide col-lg-4 col-md-4 col-xs-4 col-sm-12">
                        <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail($newphrase[0])) { echo get_the_post_thumbnail_url($newphrase[0],'large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');">
                            <a href="<?php if(get_sub_field('use_case_alternative_link')){echo get_sub_field('use_case_alternative_link'); }else{ echo get_the_permalink($newphrase[0]); } ?>"></a>
                        </div>
                        <div class="text-container">
                            <h3 class="title"><a href="<?php echo get_the_permalink($newphrase[0]); ?>"><?php echo get_the_title($newphrase[0]); ?></a></h3>
                            <div class="excerpt"><?php if(has_excerpt($newphrase[0])) { echo get_the_excerpt($newphrase[0]); }else { echo ''; }  ?></div>
                        </div>
                    </div>    
                    <?php
                    }
                    ?>
                    <?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
                    <?php endif; ?>
                    
                    
                    <?php endwhile; ?>
                    <?php endif; ?>	
                    
                    
                </div>
            <a href="<?php echo get_sub_field('link'); ?>" class="button button-fill button-cta" title="<?php echo get_sub_field('cta'); ?>"><span><?php echo get_sub_field('cta'); ?></span></a>
            
        </div>
    </div>
</section>
<?php endwhile; ?>
<?php endif; ?>	


<?php echo get_template_part('parts/part', 'cta'); ?>
<?php get_footer('custom'); ?>