//Functions to Animate the Homepage Video detecting mouse wheel OR clicking at the Button

// Based on http://www.sitepoint.com/html5-javascript-mouse-wheel/

var addMouseWheelEventListener = function (scrollHandler)
{
  if (window.addEventListener) 
  {
    // IE9+, Chrome, Safari, Opera
    window.addEventListener("mousewheel", scrollHandler, false);
    // Firefox
    window.addEventListener("DOMMouseScroll", scrollHandler, false);
  } 
  else 
  {
    // // IE 6/7/8
    window.attachEvent("onmousewheel", scrollHandler);
  }
}

addMouseWheelEventListener(handleWheel);

jQuery(document).on('touchmove', function(){
    handleWheel();
});


function handleWheel(event) 
{
  // cross-browser wheel delta
  // Chrome / IE: both are set to the same thing - WheelEvent for Chrome, MouseWheelEvent for IE
  // Firefox: first one is undefined, second one is MouseScrollEvent
  var e = window.event || event;
  // Chrome / IE: first one is +/-120 (positive on mouse up), second one is zero
  // Firefox: first one is undefined, second one is -/+3 (negative on mouse up)

  if(jQuery('.mobile-uvp').css('display') == 'block'){
    if(jQuery('.mobile-uvp').hasClass('animated')){
        return false;
      }else{
        experienceCarousel();
        jQuery('.accordion-section').slideDown();
      }
  }else{

    if(jQuery('.experience').hasClass('animated')){
        return false;
      }else{
        jQuery('.ripple').addClass('animation');
        zoomVideo();
      }
    }


  e.preventDefault();
}

function zoomVideo() {
    jQuery('.hand-video-wrapper').addClass('shake');

    jQuery('#video').css('transform', 'scale(1)');

    jQuery('.banner-text').addClass('fadeout');
            
    jQuery('#hand').css('transform', 'scale(1)');

    jQuery('.experience').addClass('animated');

    jQuery('.accordion-section').delay(2000).slideDown();

    setTimeout(function() {
        experienceCarousel();
    }, 5000);
}

//Preload images
var images = new Array()
function preload() {
    // for( i=0; i < preload.arguments.length; i++) {
    //     images[i] = new Image()
    //     images[i].src = preload.arguments[i]
    // }

    for( i=0; i < preload.length; i++) {
        images[i] = new Image()
        images[i].src = preload[i]
    }
}

var homeURL = imm_app.site_url;

preload(
    jQuery.merge([], sliderImages['desktop'], sliderImages['mobile'])
);

// preload(
//     homeURL + '/wp-content/themes/immersion/images/background-digital-experience-phone.jpg',
//     homeURL + '/wp-content/themes/immersion/images/background-digital-experience-auto.jpg',
//     homeURL + '/wp-content/themes/immersion/images/background-digital-experience-iot.jpg',
//     homeURL + '/wp-content/themes/immersion/images/background-digital-experience-game.jpg',
//     homeURL + '/wp-content/themes/immersion/images/background-device-auto-mobile.jpg',
//     homeURL + '/wp-content/themes/immersion/images/background-device-iot-mobile.jpg',
//     homeURL + '/wp-content/themes/immersion/images/background-device-phone-mobile.jpg',
//     homeURL + '/wp-content/themes/immersion/images/background-device-video-game-mobile.jpg'
// );

function experienceCarousel() {
    jQuery('.mobile-uvp').addClass('animated');
    jQuery('.banner-text').hide();
    jQuery('.hand-video-wrapper').fadeOut();

    if(jQuery('.mobile-uvp').css('display') == 'block') {
        var backgroundImages = [];

        // jQuery('.experience').css('background-image', 'url(' + homeURL + '/wp-content/themes/immersion/images/background-device-video-game-mobile.jpg)');
        jQuery('.experience').css('background-image', 'url(' + sliderImages['mobile'][3] + ')');

        for( i=1; i < sliderImages['mobile'].length; i++ ) {
            if( i == 2 ) {
                backgroundImages.push('url(' + sliderImages['mobile'][2] + ')');
                backgroundImages.push('url(' + sliderImages['mobile'][0] + ')');
            } else {
                backgroundImages.push('url(' + sliderImages['mobile'][i] + ')');
            }
        }

        // console.log(backgroundImages);

        // var backgroundImages = [
        //     'url(' + homeURL + '/wp-content/themes/immersion/images/background-device-auto-mobile.jpg)',
        //     'url(' + homeURL + '/wp-content/themes/immersion/images/background-device-iot-mobile.jpg)',
        //     'url(' + homeURL + '/wp-content/themes/immersion/images/background-device-phone-mobile.jpg)',
        //     'url(' + homeURL + '/wp-content/themes/immersion/images/background-device-video-game-mobile.jpg)'
        // ];

    } else {
        var backgroundImages = [];

        // jQuery('.experience').css('background-image', 'url(' + homeURL + '/wp-content/themes/immersion/images/background-digital-experience-game.jpg)');
        jQuery('.experience').css('background-image', 'url(' + sliderImages['desktop'][3] + ')');

        for( i=1; i < sliderImages['desktop'].length; i++ ) {
            if( i == 2 ) {
                backgroundImages.push('url(' + sliderImages['desktop'][2] + ')');
                backgroundImages.push('url(' + sliderImages['desktop'][0] + ')');
            } else {
                backgroundImages.push('url(' + sliderImages['desktop'][i] + ')');
            }
        }

        // console.log(backgroundImages);

        // var backgroundImages = [
        //     'url(' + homeURL + '/wp-content/themes/immersion/images/background-digital-experience-auto.jpg)',
        //     'url(' + homeURL + '/wp-content/themes/immersion/images/background-digital-experience-iot.jpg)',
        //     'url(' + homeURL + '/wp-content/themes/immersion/images/background-digital-experience-phone.jpg)',
        //     'url(' + homeURL + '/wp-content/themes/immersion/images/background-digital-experience-game.jpg)'
        // ];
    }

    backgroundImageCounter = 0,
    experience = jQuery('.experience');

    window.setInterval(function() {
        experience.css('background-image', backgroundImages[backgroundImageCounter]);

        backgroundImageCounter++;
        if(backgroundImageCounter >= backgroundImages.length) {
            backgroundImageCounter = 0;
        }
    }, 5000);
}

jQuery(document).ready(function($) {
    if(jQuery('.mobile-uvp').css('display') == 'block') {
        experienceCarousel();
        jQuery('.home-about').slideDown();
    }

    $('.button-touch').on('click', function(e) {
        e.preventDefault();
        
        $('.ripple').addClass('animation');
        
        if($('.experience').hasClass('animated')) {
            return false;
        } else {
            zoomVideo();
        }
    });

});

