function hapticResourceScript() {
    // Resource Article
    $(".article-news-panel").mouseenter(function() { //hover
        $(this).addClass('article-panel-hover');
    }).mouseleave(function() {
        $(this).removeClass('article-panel-hover');
    });

    $('.article-news-list li').click(function(e) { // on click any item
        e.preventDefault();

        if ($(window).width() < 992) { // for mobile on click (for left navigation)
            $('.article-news-list li').toggleClass('click'); //selected gets to be on top
            var selectedText = $(this).find('a').text(); //clicked item
            $('.article-news-list li:first-child a span.text').html(selectedText); //replace text w/ selected
            $('.article-news-list li a.active').removeClass('active');
            $('.article-news-list li:first-child a').addClass('active');
        }

        // for filter purposes (item tiles)
        var activeCategory = $(this).find('a').data('category');
        $('.' + activeCategory).show();
        $('.' + activeCategory).addClass('active-panel');
        $('.article-news-panel').not('.' + activeCategory).hide();
        $('.article-news-panel').not('.' + activeCategory).removeClass('active-panel');

        // active class on clicked item (blue font color)
        if ($(window).width() > 992) {
            $('.article-news-list li a.active').removeClass('active');
            $(this).find('a').addClass('active');    
        }

        if($('.active-panel').length > 6) {
            $(".article-news-panel-container-row").pagify(6, ".active-panel");
        } else {
            //$(".article-news-panel-container-row").pagify(6, "");
            $(".article-news-panel-container .pagination").hide();
        }
    });

    $('.article-news-list li:first-child').click(function(e) { 
        e.preventDefault();

        if ($(window).width() < 992) {
            $(this).find('a span.text').html("All Articles");
        }

        // for filter purposes
        $('.article-news-panel:lt(6)').show();
        $('.article-news-panel').addClass('active-panel');

        $(".article-news-panel-container-row").pagify(6, ".article-news-panel");
    });

    $(window).on("load resize",function(){
        $('.article-news-panel:lt(6)').show();
        $('.article-news-panel').addClass('active-panel');
        $('.article-news-list li a.active').removeClass('active');
        $('.article-news-list li:first-child a').addClass('active');

        if ($(window).width() > 992) {
            $('.article-news-list li:first-child').find('a span.text').html("All Articles");
        }

        $(".article-news-panel-container-row").pagify(6, ".article-news-panel");
    });

    // Technical Resource

    $('.technical-list li').click(function(e) { 
        e.preventDefault();

        if ($(window).width() < 992) { // for mobile on click (for left navigation)
            $('.technical-list li').toggleClass('click');
            var selectedText = $(this).find('a').text();
            $('.technical-list li:first-child a span.text').html(selectedText);
            $('.technical-list li a.activeTech').removeClass('activeTech');
            $('.technical-list li:first-child a').addClass('activeTech');
        }

        var activeCategory = $(this).find('a').data('category');
        $('.' + activeCategory).show();
        $('.' + activeCategory).addClass('active-panel-rs');
        $('.technical-panel').not('.' + activeCategory).hide();
        $('.technical-panel').not('.' + activeCategory).removeClass('active-panel-rs');

        // active class on clicked item (blue font color)
        if ($(window).width() > 992) {
            $('.technical-list li a.activeTech').removeClass('activeTech');
            $(this).find('a').addClass('activeTech');    
        }

        if($('.active-panel-rs').length > 6) {
            $(".technical-panel-container-row").pagifyTech(6, ".active-panel-rs");
            $(".technical-resources-page-row").pagifyTech(6, ".active-panel-rs");
        } else {
            $(".technical-panel-container .paginationTech").hide();
        }
    });

    $('.technical-list li:first-child').click(function(e) { 
        e.preventDefault();

        if ($(window).width() < 992) {
            $(this).find('a span.text').html("All Articles");
        }

        // for filter purposes
        $('.technical-panel:lt(6)').show();
        $('.technical-panel').addClass('active-panel-rs');

        $(".technical-panel-container-row").pagifyTech(6, ".technical-panel");
        $(".technical-resources-page-row").pagifyTech(6, ".technical-panel");
    });

    $(window).on("load resize",function(){
        $('.technical-panel:lt(6)').show();
        $('.technical-panel').addClass('active-panel-rs');
        $('.technical-list li a.activeTech').removeClass('activeTech');
        $('.technical-list li:first-child a').addClass('activeTech');

        if ($(window).width() > 992) {
            $('.technical-list li:first-child').find('a span.text').html("All Articles");
            
        }

        $(".technical-panel-container-row").pagifyTech(6, ".technical-panel");
        $(".technical-resources-page-row").pagifyTech(6, ".technical-panel");
    });

    // on load functions
//
//    $(window).on("load resize",function(){
//        // on load functions
//        $(".technical-resources-page-row").pagify(6, ".technical-panel-page");
//        $(".technical-panel-container-row").pagify(6, ".technical-panel");
//    });

    // pagination article

    (function($) {
        var pagify = {
            items: {},
            container: null,
            totalPages: 1,
            perPage: 3,
            currentPage: 0,
            createNavigation: function() {
                this.totalPages = Math.ceil(this.items.length / this.perPage);
    
                $('.pagination', this.container.parent()).remove();
                var pagination = $('<div class="pagination"></div>').append('<a class="nav prev disabled" data-next="false">Prev</a>');
    
                for (var i = 0; i < this.totalPages; i++) {
                    var pageElClass = "page";
                    if (!i)
                        pageElClass = "page current";
                    var pageEl = '<a class="' + pageElClass + '" data-page="' + (
                    i + 1) + '">' + (
                    i + 1) + "</a>";
                    pagination.append(pageEl);
                }
                pagination.append('<a class="nav next" data-next="true">Next</a>');
    
                this.container.after(pagination);
    
                var that = this;
                $("body").off("click", ".nav");
                this.navigator = $("body").on("click", ".nav", function() {
                    var el = $(this);
                    that.navigate(el.data("next"));
                });
    
                $("body").off("click", ".page");
                this.pageNavigator = $("body").on("click", ".page", function() {
                    var el = $(this);
                    that.goToPage(el.data("page"));
                });
            },
            navigate: function(next) {
                // default perPage to 5
                if (isNaN(next) || next === undefined) {
                    next = true;
                }
                $(".pagination .nav").removeClass("disabled");
                if (next) {
                    this.currentPage++;
                    if (this.currentPage > (this.totalPages - 1))
                        this.currentPage = (this.totalPages - 1);
                    if (this.currentPage == (this.totalPages - 1))
                        $(".pagination .nav.next").addClass("disabled");
                    }
                else {
                    this.currentPage--;
                    if (this.currentPage < 0)
                        this.currentPage = 0;
                    if (this.currentPage == 0)
                        $(".pagination .nav.prev").addClass("disabled");
                    }
    
                this.showItems();
            },
            updateNavigation: function() {
    
                var pages = $(".pagination .page");
                pages.removeClass("current");
                $('.pagination .page[data-page="' + (
                this.currentPage + 1) + '"]').addClass("current");
            },
            goToPage: function(page) {
    
                this.currentPage = page - 1;
    
                $(".pagination .nav").removeClass("disabled");
                if (this.currentPage == (this.totalPages - 1))
                    $(".pagination .nav.next").addClass("disabled");
    
                if (this.currentPage == 0)
                    $(".pagination .nav.prev").addClass("disabled");
                this.showItems();
            },
            showItems: function() {
                this.items.hide();
                var base = this.perPage * this.currentPage;
                this.items.slice(base, base + this.perPage).show();
    
                this.updateNavigation();
            },
            init: function(container, items, perPage) {
                this.container = container;
                this.currentPage = 0;
                this.totalPages = 1;
                this.perPage = perPage;
                this.items = items;
                this.createNavigation();
                this.showItems();
            }
        };
    
        // stuff it all into a jQuery method!
        $.fn.pagify = function(perPage, itemSelector) {
            var el = $(this);
            var items = $(itemSelector, el);
    
            // default perPage to 5
            if (isNaN(perPage) || perPage === undefined) {
                perPage = 3;
            }
    
            // don't fire if fewer items than perPage
            if (items.length <= perPage) {
                return true;
            }
    
            pagify.init(el, items, perPage);
        };
        
    })(jQuery);
    
    
    
    // Pagination for Tech
    
    (function($) {
        var pagifyTech = {
            items: {},
            container: null,
            totalPages: 1,
            perPage: 3,
            currentPage: 0,
            createNavigation: function() {
                this.totalPages = Math.ceil(this.items.length / this.perPage);
    
                $('.paginationTech', this.container.parent()).remove();
                var pagination = $('<div class="paginationTech"></div>').append('<a class="navTech prevTech disabled" data-next="false">Prev</a>');
    
                for (var i = 0; i < this.totalPages; i++) {
                    var pageElClass = "pagenumber";
                    if (!i)
                        pageElClass = "pagenumber current";
                    var pageEl = '<a class="' + pageElClass + '" data-page="' + (
                    i + 1) + '">' + (
                    i + 1) + "</a>";
                    pagination.append(pageEl);
                }
                pagination.append('<a class="navTech nextTech" data-next="true">Next</a>');
    
                this.container.after(pagination);
    
                var that = this;
                $("body").off("click", ".navTech");
                this.navigator = $("body").on("click", ".navTech", function() {
                    var el = $(this);
                    that.navigate(el.data("next"));
                });
    
                $("body").off("click", ".pagenumber");
                this.pageNavigator = $("body").on("click", ".pagenumber", function() {
                    var el = $(this);
                    that.goToPage(el.data("page"));
                });
            },
            navigate: function(nextTech) {
                // default perPage to 5
                if (isNaN(nextTech) || nextTech === undefined) {
                    nextTech = true;
                }
                $(".paginationTech .navTech").removeClass("disabled");
                if (nextTech) {
                    this.currentPage++;
                    if (this.currentPage > (this.totalPages - 1))
                        this.currentPage = (this.totalPages - 1);
                    if (this.currentPage == (this.totalPages - 1))
                        $(".paginationTech .navTech.nextTech").addClass("disabled");
                    }
                else {
                    this.currentPage--;
                    if (this.currentPage < 0)
                        this.currentPage = 0;
                    if (this.currentPage == 0)
                        $(".paginationTech .navTech.prevTech").addClass("disabled");
                    }
    
                this.showItems();
            },
            updateNavigation: function() {
    
                var pages = $(".paginationTech .pagenumber");
                pages.removeClass("current");
                $('.paginationTech .pagenumber[data-page="' + (
                this.currentPage + 1) + '"]').addClass("current");
            },
            goToPage: function(page) {
    
                this.currentPage = page - 1;
    
                $(".paginationTech .navTech").removeClass("disabled");
                if (this.currentPage == (this.totalPages - 1))
                    $(".paginationTech .navTech.nextTech").addClass("disabled");
    
                if (this.currentPage == 0)
                    $(".paginationTech .navTech.prevTech").addClass("disabled");
                this.showItems();
            },
            showItems: function() {
                this.items.hide();
                var base = this.perPage * this.currentPage;
                this.items.slice(base, base + this.perPage).show();
    
                this.updateNavigation();
            },
            init: function(container, items, perPage) {
                this.container = container;
                this.currentPage = 0;
                this.totalPages = 1;
                this.perPage = perPage;
                this.items = items;
                this.createNavigation();
                this.showItems();
            }
        };
    
        // stuff it all into a jQuery method!
        $.fn.pagifyTech = function(perPage, itemSelector) {
            var el = $(this);
            var items = $(itemSelector, el);
    
            // default perPage to 5
            if (isNaN(perPage) || perPage === undefined) {
                perPage = 3;
            }
    
            // don't fire if fewer items than perPage
            if (items.length <= perPage) {
                return true;
            }
    
            pagifyTech.init(el, items, perPage);
        };
        
        
    })(jQuery);
    

}

$(document).ready(function() {
    hapticResourceScript();
});