<?php get_header('custom'); ?>



<section class="container-padding">
    <div class="container">
        <div class="row">
            <div class="col">
                <h1 class="entry-title title-teal text-center page-title" style="margin-bottom:100px;">Blog</h1>
            </div>
        </div>
        <div class="row">
            <div class="col">
            
                <section class="blog-archive">
                    <div class="container">
                        <div class="row">
                            <div class="col-lg-9 col-md-12 col-sm-12 col-xs-12">
                
                
                <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                
                <article <?php post_class('row'); ?>>
                    <div class="image-container col-lg-4 col-md-4 col-sm-5 col-xs-12" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');">
                    <a href="<?php echo the_permalink(); ?>"></a></div>
                    <div class="text-container col-lg-8 col-md-8 col-sm-7 col-xs-12">
                        <div class="row">
                            <span class="date col-lg-6 col-md-12"><?php echo get_the_date(); ?></span>
                            <span class="categories col-lg-6 col-md-12"><?php echo the_category(); ?></span>
                        </div>
                        <h2 class="black-title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h2>
                        <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=230&length_type=characters&ellipsis=%26hellip;&exclude_tags=img,p,strong,a,h1,h2,h3,h4,h5,h6'); }  ?></div>
                        <div class="read-more"><a class="arrow-link" href="<?php echo the_permalink(); ?>">Read More</a></div>
                    </div>
                </article>
                
                <?php endwhile; endif; ?>
                                
                                <div class="row">
                            <div class="col">
                            <?php the_posts_pagination(array('screen_reader_text' => ' ')); ?>
                            </div>
                        </div>
                        </div>
                        <div class="col-lg-3 col-md-12 col-sm-12 col-xs-12 blog-sidebar">
                            <?php get_sidebar('blog'); ?>
                        </div>
                    </div>

                </div>
            </section>

            </div>
        </div>
    </div>
</section>



<?php get_footer('custom'); ?>