<?php 

/* Single Video Page */

$main_showcase = get_field('main_showcase_gallery', 'option');
$main_showcase_post = get_post($main_showcase); 
$main_showcase_slug = $main_showcase_post->post_name;
$main_showcase_title = get_the_title($main_showcase);

get_header('custom'); ?>

<?php 

	$exp = get_field('expiration', false, false);
	$currentDate = strtotime(date('Ymd'));
	$expDate = strtotime($exp);

	if($expDate >= $currentDate || empty($expDate)) {

?>

<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 white-bg single-video-page page-body container-padding" style="margin-bottom:55px;">
	<div class="container margin-top-bottom-50">
	
		<div class="col-lg-9 col-md-10 col-sm-12 col-xs-12 npd-left npd-xs video-cont">
			<div id="myElement"></div>
			<script type="text/javaScript">
				
				var player = jwplayer('myElement').setup({
					hlshtml: true,
					playlist: [{
						<?php if( get_field('video_type_opt') ): ?>
						stereomode: 'monoscopic', //if 360
						<?php endif; ?>
						image: "<?php the_field('featured_image'); ?>",
						file: '<?php the_field('video_url'); ?>'
					}]
				});
				
				jwplayer().onReady(function() {
					var videoTag = jwplayer().getContainer().querySelector('video');
					videoTag.setAttribute("id", "videohaptic");
					
					// Haptic Codes
					
					function httpRequest(location, method, body, successCallback, errorCallback) {

						var xmlHTTPRequest = new XMLHttpRequest();
						xmlHTTPRequest.open(method, location);
						xmlHTTPRequest.onerror = function(ev) {
							errorCallback(ev);
						}
						xmlHTTPRequest.onreadystatechange = function() {
							if(xmlHTTPRequest.readyState == 4 && xmlHTTPRequest.status == 200) {
								successCallback(xmlHTTPRequest);
							} else if(xmlHTTPRequest.readyState == 4 && xmlHTTPRequest.status != 200) {
								errorCallback(xmlHTTPRequest);
							}
						}
						xmlHTTPRequest.withCredentials = false;
						xmlHTTPRequest.send(body);
					}

					// how haptic player request makes http request
					function requestHapticPlayer(url, videoElement, callback) {

						// eval the result from the server (a javascript function) and provide the videoElement
						function successCallback(response) {
							var hapticPlayer = eval(response.responseText)(videoElement)
							if (callback) {
								callback(hapticPlayer);
							}
						}

						// Error Message
						function errorCallback(response) {
							if (callback) {
								callback(new Error("Got an error " + response.status + " when trying to retrieve the file."));
							}
						}

						// makes the http request
						httpRequest(url, "GET", null, successCallback, errorCallback);
					}
					
					var vid = document.getElementById("videohaptic"); 
					requestHapticPlayer("<?php the_field('haptics_url'); ?>", vid);
					
				});
				
			</script>	
			
		</div>
		

		<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 npd display-none-lg display-block-md">
	
			<h2 class="single-video-page-title"><?php the_title(); ?></h2>
			<div class="single-video-page-content">
				<?php the_content(); ?>
				
				<div class="fadeout"></div>
				
			</div>
			
			<a id="attr1_btn" class="display-none-lg display-block-xs pointer gray-border-3" style="text-align:center;padding-bottom:30px;text-transform:uppercase;font-size:14px;color:#283564;font-weight:bold;width:100%;"><u>Read More</u></a>
			
		
		</div>
		
		<script>
			
			jQuery(document).ready(function($) {
				
				$("#attr1_btn").click(function() {
					$("#attr1_div").addClass("display-block-xs");
					$(this).addClass("display-none-xs");
					$("#attr2_btn").addClass("display-block-xs");
					$("#attr2_btn").removeClass("display-none-xs");
					$(".fadeout").addClass("display-none-xs");
					$(".fadeout").removeClass("display-block-xs");
				});
				
				$("#attr2_btn").click(function() {
					$("#attr1_div").removeClass("display-block-xs");
					$(this).addClass("display-none-xs");
					$("#attr1_btn").addClass("display-block-xs");
					$("#attr1_btn").removeClass("display-none-xs");
					$(".fadeout").addClass("display-block-xs");
					$(".fadeout").removeClass("display-none-xs");
				});
			});
			
		</script>
		
		<!-- For Mobile -->
		
		<div class="col-lg-3 col-md-2 col-sm-12 col-xs-12 attributes npd-xs display-none-lg" id="attr1_div">
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-6 npd">
				
					
				<?php
					// Find connected pages
					$connected = new WP_Query( array(
					  'connected_type' => 'posts_to_pages',
					  'connected_items' => get_queried_object(),
					  'nopaging' => true,
					) );

					// Display connected pages
					if ( $connected->have_posts() ) :
					?>
					<?php while ( $connected->have_posts() ) : $connected->the_post(); ?>
					<?php 
						$title = get_the_title(); 
						if($title != $main_showcase_title) {
					?>
					
					<p><b>Promotion</b><br>
						<a href="<?php the_permalink(); ?>" style="color:rgba(35,67,115,1);"><u><b><?php echo $title; ?></b></u></a>
					</p>
					
					<?php } ?>
					<?php endwhile; ?>

					<?php 
					// Prevent weirdness
					wp_reset_postdata();

					endif;
				?>
				
				<?php
					$terms = get_the_terms( $post->ID , 'types' );
					if(!empty($terms)) { ?>
					<p><b>Type</b><br>
						<?php 
						foreach ( $terms as $term ) {
							if($term->parent == 0) {
						?>
						<a href="<?php echo esc_url( home_url() ); ?>/<?php echo $main_showcase_slug; ?>/#<?php echo $term->slug; ?>" style="color:rgba(35,67,115,1);"><u><b><?php echo $term->name; ?></b></u></a>
						<?php
							}
						} ?> 
					</p>
				<?php } ?>
				
				<!-- sub-types -->
				<?php $terms_children_counter = 0; ?>
				
				<?php if (is_array($terms) || is_object($terms)) { ?>
					<?php foreach ( $terms as $term ) { ?>

						<?php if(!empty($terms) && $term->parent !== 0) { ?>

						<?php $terms_children_counter++; ?>

						<?php } //endif ?>

					<?php } //endforeach $terms ?>
				<?php } //endif - array/object ?>
							
				<?php if($terms_children_counter > 0) { ?>
					<p><b>Vertical</b><br>
				<?php } //endif - terms counter - greater than 0 ?>
							
				<?php if (is_array($terms) || is_object($terms)) { ?>	
					<?php foreach ( $terms as $term ) { ?>
						<?php if($term->parent !== 0) { ?>

							<a href="<?php echo esc_url( home_url() ); ?>/<?php echo $main_showcase_slug; ?>/#<?php echo $term->slug; ?>" style="color:rgba(35,67,115,1);"><u><b><?php echo $term->name; ?></b></u></a>

						<?php } //endif term parent not 0 ?>						
					<?php } //endforeach - terms ?>
				<?php } //endif - array/object ?>
								
				<?php if($terms_children_counter > 0) { ?>
					</p>
				<?php } //endif - terms counter - greater than 0 ?>
						
				<!-- /sub-types -->
				
				<?php if(get_field('runtime')) { ?>
					<p><b>Runtime</b><br>
					<?php the_field('runtime'); ?></p>
				<?php } ?>
			</div>
			<div class="col-lg-12 col-md-12 col-sm-12 col-xs-6 npd">
				<?php if(get_field('language')) { ?>
					<p><b>Language</b><br>
					<?php the_field('language'); ?></p>
				<?php } ?>
				
				<?php if(get_field('country')) { ?>
					<p><b>Country</b><br>
					<?php the_field('country'); ?></p>
				<?php } ?>
				
				<?php if(get_field('year')) { ?>
					<p><b>Year</b><br>
					<?php the_field('year'); ?></p>
				<?php } ?>
				
				<?php if(get_field('copyright')) { ?>
					<p><b>Copyright</b><br>
					<?php the_field('copyright'); ?></p>
				<?php } ?>
			</div>
		</div>
		
		<a id="attr2_btn" class="display-none-lg display-none-xs pointer gray-border-3" style="text-align:center;padding-bottom:30px;text-transform:uppercase;font-size:14px;color:#283564;font-weight:bold;width:100%;"><u>Read Less</u></a>
		
		<!-- For Desktop -->
		
		<div class="col-lg-3 col-md-2 col-sm-12 col-xs-12 attributes npd-xs display-none-xs">
			<div class="col-lg-12 col-md-12 col-sm-6 col-xs-6 npd">
				
					
				<?php
					// Find connected pages
					$connected = new WP_Query( array(
					  'connected_type' => 'posts_to_pages',
					  'connected_items' => get_queried_object(),
					  'nopaging' => true,
					) );

					// Display connected pages
					if ( $connected->have_posts() ) :
					?>
					<?php while ( $connected->have_posts() ) : $connected->the_post(); ?>
					<?php 
						$title = get_the_title(); 
						if($title != $main_showcase_title) {
					?>
					
					<p><b>Promotion</b><br>
						<a href="<?php the_permalink(); ?>" style="color:rgba(35,67,115,1);"><u><b><?php echo $title; ?></b></u></a>
					</p>
					
					<?php } ?>
					<?php endwhile; ?>

					<?php 
					// Prevent weirdness
					wp_reset_postdata();

					endif;
				?>
				
				<?php $terms = get_the_terms( $post->ID , 'types' ); ?>
													 								 
				<?php if(!empty($terms)) { ?>
					<p><b>Type</b><br>
						<?php 
						foreach ( $terms as $term ) {
							if($term->parent == 0) {
						?>
						<a href="<?php echo esc_url( home_url() ); ?>/<?php echo $main_showcase_slug; ?>/#<?php echo $term->slug; ?>" style="color:rgba(35,67,115,1);"><u><b><?php echo $term->name; ?></b></u></a>
						<?php
							}
						} ?> 
					</p>
				<?php } ?>
				
				<!-- sub-types -->
				<?php $terms_children_counter = 0; ?>
				
				<?php if (is_array($terms) || is_object($terms)) { ?>
					<?php foreach ( $terms as $term ) { ?>

						<?php if(!empty($terms) && $term->parent !== 0) { ?>

						<?php $terms_children_counter++; ?>

						<?php } //endif ?>

					<?php } //endforeach $terms ?>
				<?php } //endif - array/object ?>
							
				<?php if($terms_children_counter > 0) { ?>
					<p><b>Vertical</b><br>
				<?php } //endif - terms counter - greater than 0 ?>
							
				<?php if (is_array($terms) || is_object($terms)) { ?>	
					<?php foreach ( $terms as $term ) { ?>
						<?php if($term->parent !== 0) { ?>

							<a href="<?php echo esc_url( home_url() ); ?>/<?php echo $main_showcase_slug; ?>/#<?php echo $term->slug; ?>" style="color:rgba(35,67,115,1);"><u><b><?php echo $term->name; ?></b></u></a>

						<?php } //endif term parent not 0 ?>						
					<?php } //endforeach - terms ?>
				<?php } //endif - array/object ?>
								
				<?php if($terms_children_counter > 0) { ?>
					</p>
				<?php } //endif - terms counter - greater than 0 ?>
						
				<!-- /sub-types -->
							
								
				<?php if(get_field('runtime')) { ?>
					<p><b>Runtime</b><br>
					<?php the_field('runtime'); ?></p>
				<?php } ?>
				
			</div>
			<div class="col-lg-12 col-md-12 col-sm-6 col-xs-6 npd">
				<?php if(get_field('language')) { ?>
					<p><b>Language</b><br>
					<?php the_field('language'); ?></p>
				<?php } ?>
				
				<?php if(get_field('country')) { ?>
					<p><b>Country</b><br>
					<?php the_field('country'); ?></p>
				<?php } ?>
				
				<?php if(get_field('year')) { ?>
					<p><b>Year</b><br>
					<?php the_field('year'); ?></p>
				<?php } ?>
				
				<?php if(get_field('copyright')) { ?>
					<p><b>Copyright</b><br>
					<?php the_field('copyright'); ?></p>
				<?php } ?>
			</div>
		</div>
		
		<div class="page-cont col-lg-12 col-md-12 col-sm-12 col-xs-12 npd display-none-md">
	
			<h2 class="single-video-page-title"><?php the_title(); ?></h2>
			<div class="single-video-page-content">
				<?php the_content(); ?>
			</div>
		
		</div>
		
		<div class="related-vid col-lg-12 col-md-12 col-sm-12 col-xs-12 npd margin-top-40-xs">

			<div class="related-videos">
				
				<h6 class="related-videos-title related-videos-title-xs text-center-xs"><b>Related Videos</b></h6>

				<?php 
					// get the custom post type's taxonomy terms

					$custom_taxterms = wp_get_object_terms( $post->ID, 'types', array('fields' => 'ids') );
					$custom_taxterms_promo = wp_get_object_terms( $post->ID, 'promotions', array('fields' => 'ids') );
					// arguments
					$args = array(
					'post_type' => 'showcase_video',
					'post_status' => 'publish',
					'posts_per_page' => 3, // you may edit this number
					'orderby' => 'rand',
					'tax_query' => array(
						'relation' => 'OR',
						array(
							'taxonomy' => 'types',
							'field' => 'id',
							'terms' => $custom_taxterms
						),
						array(					
							'taxonomy' => 'promotions',
							'field'    => 'term_id',
							'terms'    => $custom_taxterms_promo
						)
					),
					'post__not_in' => array ($post->ID),
					);
					$related_items = new WP_Query( $args );																		 
													 
					// loop over query
					if ($related_items->have_posts()){
					echo '<div class="display-flex-row">';
													 
					$rel_type = 0;
					$rel_type_arr = [];
					while ( $related_items->have_posts() ) : $related_items->the_post(); 
					$rel_type++;
					$exp = get_field('expiration', false, false);
					$currentDate = strtotime(date('Ymd'));
					$expDate = strtotime($exp);

					if($expDate >= $currentDate || empty($expDate)) {
						

					?>
						<div class="col-lg-3 col-md-3 col-sm-6 col-xs-12 video-thumb margin-top-bottom-sm npd-left npd-right-xs">
						<a href="<?php the_permalink(); ?>">
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 npd <?php echo $rel_type; ?>" style="margin-bottom:10px;">
								<i class="fa fa-play related" aria-hidden="true"></i>
								<img src="<?php the_field('featured_image'); ?>" class="img-responsive video-thumb-img-related">
							</div>
							<span class="category-title">
								<?php
									$types = get_the_terms($post->ID,'types');
									$promotions = get_the_terms($post->ID,'promotions');

									if(!empty($types) && empty($promotions)) {
										foreach($types as $type) { 
											if($type->parent == 0) {
												echo $type->name;
											}
										}
									}

									if(!empty($promotions) && empty($types)) {
										foreach($promotions as $promotion) { 
											if($promotion->parent == 0) {
												echo $promotion->name;
											}
										}
									}

									if(!empty($promotions) && !empty($types)) {
										foreach($types as $type) { 
											if($type->parent == 0) {
												echo $type->name; echo ' / ';
											}
										}
										foreach($promotions as $promotion) { 
											if($promotion->parent == 0) {
												echo $promotion->name;
											}
										}
									}
								?>
							</span>
							<p class="desc"><?php the_title(); ?></p>
						</a>
						</div>
						
					<?php array_push($rel_type_arr, $rel_type); } 
					
					
													 
					if(count($rel_type_arr) == 0) { ?>
					
					<style>
						.related-videos-title {
							display: none;
						}
						
						.gray-border-3 {
							border-bottom: none !important;
						}
					</style>
																	
					<?php }
					
					endwhile;
					echo '</div>';
					} else { 
				
				?>
				
					<style>
						.related-videos-title {
							display: none;
						}
						
						.gray-border-3 {
							border-bottom: none !important;
						}
					</style>
					
						
				<?php
					}
					// Reset Post Data
					wp_reset_postdata();
				?>
				
				

			</div>
			
		</div>
		
		
		
		
		
	</div>
</div>

<?php } else { ?>

	<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 white-bg single-video-page page-body" style="margin-bottom:55px;">
		<div class="container margin-top-bottom-50">

	<div class="hero-unit">

		<h1>Video has expired.</h1>
		<p>Redirecting now to the Showcase Page.</p>
		
		<?php
			// Find connected pages
			$connected = new WP_Query( array(
			  'connected_type' => 'posts_to_pages',
			  'connected_items' => get_queried_object(),
			  'nopaging' => true,
			) );

			// Display connected pages
			if ( $connected->have_posts() ) : $i = 0
			?>
			<?php while ( $connected->have_posts() ) : $connected->the_post(); ?>
			
			
				<?php 
		
					//var_dump($post); 
					if($post->post_name == $main_showcase_slug) {
						$showcase_link = get_permalink($post->ID);
						header( "refresh:1;url=$showcase_link" );
						break;
					} else {
						$showcase_link = get_permalink($post->ID);
						header( "refresh:1;url=$showcase_link" );
						break;
					}
					
				?>
			
			<?php endwhile; ?>

			<?php 
			wp_reset_postdata();

			endif;
		?>
		
	</div>

		</div>
	</div>

<?php } ?>
<div class="showcase-video-footer">
<?php get_footer('custom'); ?>
</div>