<?php 

/* Single Gallery Page */

$main_showcase = get_field('main_showcase_gallery', 'option'); //get selected main showcase post id

// Video Gallery Page

// add_action( 'wp_enqueue_scripts', 'immersion_script' );
// function immersion_script() {
// 	wp_enqueue_script( 'immersion_video', get_stylesheet_directory_uri() . '/dist/js/video-showcase.js', array(), null);
// }

get_header('custom'); ?>

<section class="investor-title container-padding top-section" style="background-image:url('<?php the_field('hero_image'); ?>');">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h1 class="page-title"><?php the_title(); ?></h1>
                <p><?php the_field('showcase_subtitle'); ?></p>
            </div>
        </div>
    </div>
</section>

<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 android-msg-cont">
    <h2 class="android-msg"><?php the_field('android_message'); ?></h2>
</div>


<?php

    // Find connected pages
	$connected = new WP_Query( array(
		'connected_type' => 'posts_to_pages',
		'connected_items' => $post,
		'nopaging' => true
	) );

	$type_name_arr = [[]];
	$promotion_name_arr = [[]];
	while ( $connected->have_posts() ) : $connected->the_post();

		$exp = get_field('expiration', false, false);
		$currentDate = strtotime(date('Ymd'));
		$expDate = strtotime($exp);

		if($expDate >= $currentDate || empty($expDate)) {

			$id = get_the_ID();
			$types = get_the_terms($id,'types');
			$promotions = get_the_terms($id,'promotions');


			// Types
			
			if (is_array($types) || is_object($types)) {			
				foreach ($types as $type) {
					array_push($type_name_arr, array("id"=>$type->term_id, "name"=>$type->name, "slug"=>$type->slug, "parent"=>$type->parent));
				}
			}           
            
			// Promotions
			if (is_array($promotions) || is_object($promotions)) {
				foreach ($promotions as $promotion) {
                    array_push($promotion_name_arr, array("id"=>$promotion->term_id, "name"=>$promotion->name, "slug"=>$promotion->slug, "parent"=>$promotion->parent));
                }
			}

		}
	
	
	endwhile;

	wp_reset_postdata(); // set $post back to original post

    // Declare Terms
    $terms_name = array_map("unserialize", array_unique(array_map("serialize", $type_name_arr)));
                                  
    // sort alphabetically
    function compareByName($a, $b) {
        return strcmp($a["name"], $b["name"]);
    }
    usort($terms_name, 'compareByName');
                                  
    $terms = array_filter($terms_name);
                                  
    $promos_name = array_map("unserialize", array_unique(array_map("serialize", $promotion_name_arr)));
                                  
    // sort alphabetically
    function compareByNamePromo($a, $b) {
        return strcmp($a["name"], $b["name"]);
    }
    usort($promos_name, 'compareByNamePromo');
                                  
    $promos = array_filter($promos_name);
                                  
//    echo '<pre>';
//    print_r($promos);
//    echo '</pre>';
    

?>

<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 npd white-bg page-body" style="margin-bottom:55px;">
    
	<div class="container cat-container margin-top-bottom-50 npd-xs border-btm-xs nmg-top-xs"
         style="margin-bottom:0px;<?php if(!empty($promos)){ echo 'margin-top:0px;'; } ?>">
		
		<?php 

			if(!empty($terms) && is_single($main_showcase)) :
        
				$btn_id = "#navigation_main_showcase";
        
            elseif(!empty($promos)) :
        
				$btn_id = "#promotion_nav";
        
			endif; 

		?>
		
		<nav class="navbar navbar-default">
            
			<div class="container-fluid showcase-nav-collapsed npd-sides-xs nmg-sides-xs">
			<!-- Brand and toggle get grouped for better mobile display -->
                
				<div class="navbar-header"><!-- style="border-bottom:1px solid #e7e7e7;"-->
                    
					<button type="button" class="navbar-toggle collapsed navbar-categories-xs navbar-category-main" data-toggle="collapse" data-target="<?php echo $btn_id; ?>" aria-expanded="false">
                        
						<span>Categories</span>
                        
					</button>
                    
					<?php //if(empty($promos)) : ?>
                    
                        <span class="placeholder-cat text-center">All</span>
                    
                    <?php //endif; ?>
                    
				</div>
            
				<!-- Collect the nav links, forms, and other content for toggling -->
               
                <?php if(!empty($terms) && is_single($main_showcase)) : ?>
                
                <div class="showcase-nav collapse navbar-collapse nmg-bottom-xs npd-sides-xs nmg-sides-xs" id="navigation_main_showcase" style="margin-top:40px;">
                    
                    <div class="showcase-nav container container-maxed text-center navbar-collapse nmg-bottom-xs npd-sides-xs nmg-sides-xs">

                        <a href = "#" data-filter="all" class="is-checked all-link pointer active"><span>All</span></a>

                        <?php $i = 0; ?>

                        <?php $terms_parent = []; ?>

                        <?php $terms_parent_id = []; ?>

                        <?php foreach ($terms as $term) : $i++; ?>

                            <?php if($term != null) : ?>
                               
                                <?php if($term['parent'] == 0) : ?>

                                    <?php array_push($terms_parent, $term['slug']); ?>

                                    <?php array_push($terms_parent_id, $term['id']); ?>

                                    <a href="#<?php echo $term['slug']; ?>" data-toggle="collapse" data-target="#<?php echo $term['slug']; ?>"
                                       class="<?php echo $term['slug']; echo ' '; echo $term['id']; ?> showcase-main-link pointer">
                                        <span><?php echo $term['name']; ?></span>
                                    </a>

                                <?php endif; //endif -- parent ?>
                                
                            <?php endif; //endif -- parent term not null ?>

                        <?php endforeach; //endforeach ?>
                        
                        

                    </div>

                </div>
                
                <?php elseif(!empty($promos)) : ?>
                
                <div class="showcase-nav collapse navbar-collapse showcase-nav-promotion" id="promotion_nav">

                    <div class="showcase-nav container container-maxed text-center navbar-collapse">

                        <?php if(!empty($promos)) : ?>

                        <a href="#" data-filter="all" class="is-checked all-link pointer active"><span>All</span></a>

                        <?php foreach ($promos as $promo) : ?>
                            
                            <?php if($promo['parent'] != 0) : ?>

                            <!--<span class="divi display-none-xs">|</span>
                            <a class="<?php //echo $promo->slug; ?> pointer"><?php //echo $promo->name; ?></a>-->
                            
                            <a href="#<?php echo $promo['slug']; ?>" data-toggle="collapse" data-target="#<?php echo $promo['slug']; ?>"
                            class="<?php echo $promo['slug']; echo ' '; echo $promo['id']; ?> showcase-main-link pointer">
								<span><?php echo $promo['name']; ?></span>
							</a>
                        
                            <?php endif; //endif -- parent ?>

                        <?php endforeach; ?>

                        <?php endif; ?>

                    </div>

                </div>

                <?php endif; ?>
				
            </div> <!--   container-fluid showcase-nav-collapsed -->
            
		</nav>
        
	</div>
    
    <?php if(is_single($main_showcase)) : ?>
    
    <?php if(!empty($terms)) : $i = 0; ?>
    
	<div class="verticals">	
        
		<nav class="navbar navbar-default">
            
			<div class="container-fluid showcase-nav-collapsed npd-sides-xs nmg-sides-xs npd">
                
				<div class="navbar-header navbar-header-verticals">
                    
					<button type="button" class="navbar-toggle collapsed vertical-btn navigation-children" data-toggle="collapse" data-target="#navigation_children" aria-expanded="false">
						<span>Verticals</span>
					</button>
               
                    
                    <span class="placeholder-vertical text-center">&nbsp;</span>
                    
				</div>
				
				<div class="showcase-nav collapse navbar-collapse" id="navigation_children">
                    
					<div class="showcase-nav container container-maxed text-center navbar-collapse">
					
						<!-- child categories -->
						
				        <?php foreach($terms_parent as $im_parent) : ?>
                                             
                       		<?php $category_counter = 0; ?>

							<?php foreach ($terms as $term) : ?>

								<?php if(($term['parent'] !== 0) && ($term['parent'] == $terms_parent_id[$i])) : ?>

									<?php $category_counter++; ?>

								<?php endif; ?>

							<?php endforeach; ?>
                        
							<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 collapse showcase-main-link-child verticals-container npd-sides-xs npd 
							<?php if($category_counter == 0) { echo "mobile-disabled"; } else { echo "vertical-gray-bg"; }?>" id="<?php echo $im_parent; ?>">

                                <?php if($category_counter != 0) { ?>
                                
                                <div class = "verticals-menu fourths">
                                
									<?php 
									
										if($category_counter <= 6) { 
											$number_of_columns = 2;
										} elseif($category_counter <= 9) {
											$number_of_columns = 3;
										} else {
											$number_of_columns = 4;
										}
			
										if(ceil($category_counter/$number_of_columns) <= 1) {
											$modulo_condition = 0;
										} else {
											$modulo_condition = 1;
										}
									
									?>                                								  
                                								  								  								  
								<?php $menu_row_item = 1; ?>
                                    
								<?php $item_counter = 0; ?>
                                    
                                <?php foreach ($terms as $term) : ?>

                                    <?php if(($term['parent'] !== 0) && ($term['parent'] == $terms_parent_id[$i])) : ?>

                                        <?php $item_counter++; ?>
                                    
                                        <?php $number_of_items_per_row = ceil($category_counter/$number_of_columns); ?>

                                        <?php if($menu_row_item%$number_of_items_per_row == $modulo_condition) : ?> <div class = "menu-item-row"> <?php endif; ?>

                                        <span class = "verticals-menu-item">

                                            <a href="#<?php echo $term['slug']; ?>" class="<?php echo $term['slug']; ?> pointer child border-btm-light-xs"><?php echo $term['name']; ?></a>

                                        </span>

                                        <?php if(($menu_row_item%$number_of_items_per_row == 0) || ($category_counter == $item_counter)) : ?> </div> <?php endif; ?>

                                        <?php $menu_row_item++; ?>

                                        <?php if($category_counter == $item_counter): $item_counter = 0; endif; ?>

                                    <?php endif; ?>

                                <?php endforeach; ?>
                                    
                                </div>
                                
								<?php } ?>
                                
							</div>
                        
							<?php $i++; ?>
                        
                        <?php endforeach; ?>
                        
					</div>
                    
				</div>
                
			</div>
            
		</nav>
        
	</div>
    
    <?php endif; ?>
    
    <?php endif; //endif - main showcase ?>
					
	<!--------------------------------------------------------------------------->
		
	<div class="container margin-top-bottom-50 videos-container display-flex-row">
		<?php
			// Find connected pages
			$connected = new WP_Query( array(
			  'connected_type' => 'posts_to_pages',
			  'connected_items' => get_queried_object(),
			  'nopaging' => true,
			) );

			// Display connected pages
			if ( $connected->have_posts() ) :
			?>
			
			<?php //$connected_items = []; ?>
			
			<?php while ( $connected->have_posts() ) : $connected->the_post(); ?>
			
			
			<?php
				$exp = get_field('expiration', false, false);
				$currentDate = strtotime(date('Ymd'));
				$expDate = strtotime($exp);
				
				if($expDate >= $currentDate || empty($expDate)) {

			?>
			
					<?php 
					
						// for count of available videos/cats
						/*$types = get_the_terms($post->ID,'types'); 
						foreach($types as $type) { 
							if($type->parent == 0) {
								array_push($connected_items, $type->slug); //term_id
							}
						}*/
					
					?>
						
					<div class="col-xs-12 video-thumb margin-top-bottom-sm <?php $types = get_the_terms($post->ID,'types'); $promotions = get_the_terms($post->ID,'promotions'); if(!empty($types)) { foreach($types as $type) { echo ' '; echo $type->slug; } } if(!empty($promotions)) { foreach($promotions as $promotion) { echo ' '; echo $promotion->slug; } }	?>">
						<a href="<?php the_permalink(); ?>" style="position:relative;z-index:5;">
						<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 npd vid-container">
							<i class="fa fa-play transparent" aria-hidden="true"></i>
							<div class="video-thumb-overlay npd">
								<div class="text-container">
									<span class="category-title">
										<?php
											$types = get_the_terms($post->ID,'types');
											$promotions = get_the_terms($post->ID,'promotions');

											if(!empty($types) && empty($promotions)) {
												foreach($types as $type) { 
													if($type->parent == 0) {
														echo $type->name;
													}
												}
											}

											if(!empty($promotions) && empty($types)) {
												foreach($promotions as $promotion) { 
													if($promotion->parent == 0) {
														echo $promotion->name;
													}
												}
											}
					
											if(!empty($promotions) && !empty($types)) {
												foreach($types as $type) { 
													if($type->parent == 0) {
														echo $type->name; echo ' / ';
													}
												}
												foreach($promotions as $promotion) { 
													if($promotion->parent == 0) {
														echo $promotion->name;
													}
												}
											}
										?> 
									</span>
									<h3 class="video-title"><?php the_title(); ?></h3>
									<i class="fa fa-play" aria-hidden="true"></i>
								</div>
							</div>
							<img src="<?php the_field('featured_image')?>" class="img-responsive video-thumb-img">
						</div>
						<div class="mobile-desc">
							<span class="category-title">
								<?php
									$types = get_the_terms($post->ID,'types');
									$promotions = get_the_terms($post->ID,'promotions');

									if(!empty($types) && empty($promotions)) {
										foreach($types as $type) { 
											if($type->parent == 0) {
												echo $type->name;
											}
										}
									}

									if(!empty($promotions) && empty($types)) {
										foreach($promotions as $promotion) { 
											if($promotion->parent == 0) {
												echo $promotion->name;
											}
										}
									}

									if(!empty($promotions) && !empty($types)) {
										foreach($types as $type) { 
											if($type->parent == 0) {
												echo $type->name; echo ' / ';
											}
										}
										foreach($promotions as $promotion) { 
											if($promotion->parent == 0) {
												echo $promotion->name;
											}
										}
									}
								?> 								
							</span>
                            <h3 class="video-title"><?php the_title(); ?></h3>
						</div>
						</a>
					</div>
				
				
			<?php } //endif -- date 
			endwhile; ?>

			<?php 
			// Prevent weirdness
			wp_reset_postdata();

			endif;
		?>
		
		<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 video-thumb margin-top-bottom-sm dont-none">&nbsp;</div>
		<div class="col-lg-4 col-md-4 col-sm-6 col-xs-12 video-thumb margin-top-bottom-sm dont-none">&nbsp;</div>
		
	</div>
</div>

<?php get_footer('custom'); ?>