<?php
/*
	Template Name: Technical Resources
*/

get_header('custom'); ?>

<section class="haptic-resource-title container-padding top-section" style="background-image:url('<?php echo get_field('banner'); ?>');">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h1 class="page-title"><?php single_post_title(); ?></h1>
                <p><?php echo get_field('page_description'); ?></p>
            </div>
        </div>
    </div>
</section>

<section class="haptic-resource-technical">
    <div class="container">
        <h5 class="haptic-resource-technical-title">Technical Resources</h5>
        <div class="row haptic-resource-technical-row">
            <div class="col-lg-3 technical-list-container">
                <?php 
                $terms = get_field('technical_resources_categories');
                if( $terms ): ?>
                    <ul class="technical-list">
                    <li><a href="#" class="activeTech"><span class="text">All Articles</span> <span class="arrow">&#9660;</span></a></li>
                    <?php foreach( $terms as $term ): ?>
                        <li><a href="#" data-category="<?php echo get_cat_slug($term); ?>"><?php echo get_cat_name($term);?></a></li>
                    <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
            <div class="technical-panel-container col-lg-9">
                <div class="technical-resources-page-row row">
                <?php 
                    $terms = get_field('technical_resources_categories');
                    //foreach( $terms as $term ) :
                        $args = array( 
                            'post_type' => 'technical_resources', 
                            'post_status'=>'publish', 
                            // 'category__in' => array($term), 
                            'posts_per_page'=>-1 ,
                            'tax_query' => array(
                                array(
                                    'taxonomy' => 'category', //double check your taxonomy name in you dd 
                                    'field'    => 'id',
                                    'terms'    => $terms,
                                ),
                            ),
                        );
                    $the_query = new WP_Query( $args );
                ?>
                <?php if ( $the_query->have_posts() ) : ?>
                <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                <?php $c = get_the_category(); ?>
                <div class="col-lg-6 technical-panel technical-panel-page <?php echo $c[0]->category_nicename; ?>">
                    <div>
                        <?php 
                            if(has_post_thumbnail()){
                                the_post_thumbnail();
                            }
                        ?>
                    </div>
                    <div class="technical-panel-description">
                        <h6><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h6>
                        <p><?php the_excerpt(); ?></p>
                        <p><a href="<?php the_permalink(); ?>" class="arrow-link">Read the article</a></p>
                    </div>
                </div>
                <?php wp_reset_postdata(); ?>
                <?php endwhile; ?>
                <?php endif; ?>                                
                <?php //endforeach; // for terms ?>
                </div>
                <div class="article-news-pagination-wrapper">
                    <div class="article-news-more-cta">
                        <p><a href="<?php echo get_site_url(); ?>/haptic-resources/" class="cta-link">Back to Resource Center</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer('custom'); ?>