<?php
/*
	Template Name: Investors
*/

get_header('custom'); ?>


<section class="investor-title container-padding top-section"
		 style="background-image:url('<?php echo get_field('section_background')['url']; ?>');">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h1 class="page-title"><?php echo get_field('page_title'); ?></h1>
            </div>
        </div>
    </div>
</section>

<section class="investor-technology container-padding">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h2 class="title-teal"><?php echo get_field('section_2_title'); ?></h2>
                <p><?php echo get_field('section_2_description'); ?></p>
            </div>
        </div>
    </div>
</section>

<section class="investor-stock container-padding">
    <div class="container">
        <div class="row">
            <div class="col">
                <h2><?php echo get_field('immr_stock_title'); ?></h2>
                <?php echo get_field('immr_stock_iframe'); ?>
                <a href="<?php echo get_field('immr_stock_button_url'); ?>"
				   class="button button-fill cta-button"
				   title="<?php echo get_field('immr_stock_button_text'); ?>"
				   target="_blank">
					<span><?php echo get_field('immr_stock_button_text'); ?></span>
				</a>
            </div>
        </div>
    </div>
</section>

<section class="investor-links">
        <div class="row">
            <?php if( have_rows('investor_links') ): $count=0; ?>
            <?php while( have_rows('investor_links') ): the_row(); ?> 
            <div class="link-box <?php if($count==0 || $count==3){echo 'bgimage';} ?> col-lg-6 col-md-6 col-sm-12"
				 style="background-image:url('<?php echo get_sub_field('background')['url']; ?>');">
                <div class="container-padding col-lg-9 offset-lg-1 col-md-10 offset-md-1">
                    <h2><?php echo get_sub_field('title'); ?></h2>
                    <p><?php echo get_sub_field('desciption'); ?></p>
                    <a class="<?php if($count==0 || $count==3) echo 'cta-button'; else echo 'cta-link'; ?>"
					   href="<?php echo get_sub_field('button_url'); ?>"
					   <?php if($count==0) echo 'target="_blank"';?>>
						<?php echo get_sub_field('button_text'); ?>
					</a>
                </div>
            </div>
            <?php $count++; endwhile; ?>
            <?php endif; ?>
        </div>
</section>


<?php get_footer('custom'); ?>