<?php
/*
	Template Name: Use Cases 2
*/

get_header('custom'); ?>


<section class="usecase-header container-padding top-section">
    <div class="container">
        <div class="row">
            <h1 class="page-title"><?php echo get_field('info_title'); ?></h1>
            <?php echo get_field('info_description'); ?>
        </div>
    <div class="row links-wrap button-animation">
            <?php if( have_rows('navigation') ): ?>
            <?php while( have_rows('navigation') ): the_row();?>
            <div class="link-item col">
                <a href="#<?php echo get_sub_field('href'); ?>" title="<?php echo get_sub_field('line1'); ?>" class="icon-link scroll">
                    <div class="button-wrap">
                        <svg class="outer-circle-wrap" width="110" height="120" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="outer circle-outer-1" id="circle-outer-1" d="M59,5c30.38,0,56,24.62,56,55s-24.62,55-55,55S5,90.38,5,60S28.62,5,59,5z" fill-rule="nonzero" fill="#070707" />
                            <path class="outer blob-outer-1" id="blob-outer-1" d="M13.55,38.75C23.58,8.8,64.45,12.25,89.5,14.53c27.25,2.48,34.29,40.4,8.58,62.43 	c-18.64,15.98-35.86,41.94-59.19,28.38S-0.57,80.91,13.55,38.75z" fill-rule="nonzero" />
                        </svg>
                        <svg class="inner-circle-wrap" width="110" height="120" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="inner circle-inner-1" id="circle-inner-1" d="M59,15c24.85,0,46,20.15,46,45s-20.15,45-45,45S15,84.85,15,60S34.15,15,59,15z" fill-rule="nonzero" />
                            <path class="inner blob-inner-1" id="blob-inner-1" d="M10.27,59.49C30.64,39.13,25.28,6.97,58.51,11.26c26.42,3.41,33.22,14.83,42.88,39.66 c15.01,38.59-9.81,49.31-36.45,49.31S-8.57,78.33,10.27,59.49z" />
                        </svg>
                        <div class="button-touch"><img src="<?php echo get_sub_field('icon')['url']; ?>" alt="" class="icon"></div>
                    </div>
                    <span class="title"><?php echo get_sub_field('line1'); ?></span>
                </a>
            </div>
            <?php endwhile; ?>
            <?php endif; ?>										
        </div>
    </div>
</section>


<section class="case-block" id="<?php echo get_field('id_automotives'); ?>">
    <div class="section-title" style="background-image:url('<?php echo get_field('background_automotives')['url']; ?>');">
        <div class="icon-image">
            <div class="outer-circle">
                <div class="inner-circle">
                    <div class="icon"><img src="<?php echo get_field('icon_automotives')['url']; ?>" alt="icon"></div>
                </div>
            </div>
        </div>
        <h2 class="title"><?php echo get_field('title_automotives'); ?></h2>
    </div>
    <div class="section-slider">
        
        <div class="slider-container container">
                <div class="row">
                    
                    
                    <?php if( have_rows('featured_gallery_automotives') ): ?>
                    <?php while( have_rows('featured_gallery_automotives') ): the_row();?>
                    
                    <?php

                    $post_object = get_sub_field('featured_automotives');

                    if( $post_object ): 

                        // override $post
                        $post = $post_object;
                        setup_postdata( $post ); 

                        ?>
                    
                    <div class="swiper-slide col-lg-4 col-md-4 col-xs-4 col-sm-12">
                        <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');"><a href="<?php if(get_sub_field('alternative_link_automotives')){echo get_sub_field('alternative_link_automotives'); }else{ echo the_permalink(); } ?>"></a></div>
                        <div class="text-container">
                            <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                            <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=1&finish=sentence&length_type=characters&ellipsis=&exclude_tags=img,p,strong,figure,video'); }  ?></div>
                        </div>
                    </div>
                    
                    <?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
                    <?php endif; ?>
                    
                    
                    <?php endwhile; ?>
                    <?php endif; ?>	
                    
                    
                </div>
            <a href="<?php echo get_field('link_automotives'); ?>" class="button button-fill button-cta" title="<?php echo get_field('cta_automotives'); ?>"><span><?php echo get_field('cta_automotives'); ?></span></a>
            
        </div>
    </div>
</section>



<section class="case-block" id="<?php echo get_field('id_mobile'); ?>">
    <div class="section-title" style="background-image:url('<?php echo get_field('background_mobile')['url']; ?>');">
        <div class="icon-image">
            <div class="outer-circle">
                <div class="inner-circle">
                    <div class="icon"><img src="<?php echo get_field('icon_mobile')['url']; ?>" alt="icon"></div>
                </div>
            </div>
        </div>
        <h2 class="title"><?php echo get_field('title_mobile'); ?></h2>
    </div>
    <div class="section-slider">
        
        <div class="slider-container container">
                <div class="row">
                    
                    
                    <?php if( have_rows('featured_gallery_mobile') ): ?>
                    <?php while( have_rows('featured_gallery_mobile') ): the_row();?>
                    
                    <?php

                    $post_object = get_sub_field('featured_mobile');

                    if( $post_object ): 

                        // override $post
                        $post = $post_object;
                        setup_postdata( $post ); 

                        ?>
                    
                    <div class="swiper-slide col-lg-4 col-md-4 col-xs-4 col-sm-12">
                        <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');"><a href="<?php if(get_sub_field('alternative_link_mobile')){echo get_sub_field('alternative_link_mobile'); }else{ echo the_permalink(); } ?>"></a></div>
                        <div class="text-container">
                            <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                            <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=1&finish=sentence&length_type=characters&ellipsis=&exclude_tags=img,p,strong,figure,video'); }  ?></div>
                        </div>
                    </div>
                    
                    <?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
                    <?php endif; ?>
                    
                    
                    <?php endwhile; ?>
                    <?php endif; ?>	
                    
                    
                </div>
            <a href="<?php echo get_field('link_mobile'); ?>" class="button button-fill button-cta" title="<?php echo get_field('cta_mobile'); ?>"><span><?php echo get_field('cta_mobile'); ?></span></a>
            
        </div>
    </div>
</section>


<section class="case-block" id="<?php echo get_field('id_iot'); ?>">
    <div class="section-title" style="background-image:url('<?php echo get_field('background_iot')['url']; ?>');">
        <div class="icon-image">
            <div class="outer-circle">
                <div class="inner-circle">
                    <div class="icon"><img src="<?php echo get_field('icon_iot')['url']; ?>" alt="icon"></div>
                </div>
            </div>
        </div>
        <h2 class="title"><?php echo get_field('title_iot'); ?></h2>
    </div>
    <div class="section-slider">
        
        <div class="slider-container container">
                <div class="row">
                    
                    
                    <?php if( have_rows('featured_gallery_iot') ): ?>
                    <?php while( have_rows('featured_gallery_iot') ): the_row();?>
                    
                    <?php

                    $post_object = get_sub_field('featured_iot');

                    if( $post_object ): 

                        // override $post
                        $post = $post_object;
                        setup_postdata( $post ); 

                        ?>
                    
                    <div class="swiper-slide col-lg-4 col-md-4 col-xs-4 col-sm-12">
                        <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');"><a href="<?php if(get_sub_field('alternative_link_iot')){echo get_sub_field('alternative_link_iot'); }else{ echo the_permalink(); } ?>"></a></div>
                        <div class="text-container">
                            <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                            <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=1&finish=sentence&length_type=characters&ellipsis=&exclude_tags=img,p,strong,figure,video'); }  ?></div>
                        </div>
                    </div>
                    
                    <?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
                    <?php endif; ?>
                    
                    
                    <?php endwhile; ?>
                    <?php endif; ?>	
                    
                    
                </div>
            <a href="<?php echo get_field('link_iot'); ?>" class="button button-fill button-cta" title="<?php echo get_field('cta_iot'); ?>"><span><?php echo get_field('cta_iot'); ?></span></a>
            
        </div>
    </div>
</section>


<section class="case-block" id="<?php echo get_field('id_gaming'); ?>">
    <div class="section-title" style="background-image:url('<?php echo get_field('background_gaming')['url']; ?>');">
        <div class="icon-image">
            <div class="outer-circle">
                <div class="inner-circle">
                    <div class="icon"><img src="<?php echo get_field('icon_gaming')['url']; ?>" alt="icon"></div>
                </div>
            </div>
        </div>
        <h2 class="title"><?php echo get_field('title_gaming'); ?></h2>
    </div>
    <div class="section-slider">
        
        <div class="slider-container container">
                <div class="row">
                    
                    
                    <?php if( have_rows('featured_gallery_gaming') ): ?>
                    <?php while( have_rows('featured_gallery_gaming') ): the_row();?>
                    
                    <?php

                    $post_object = get_sub_field('featured_gaming');

                    if( $post_object ): 

                        // override $post
                        $post = $post_object;
                        setup_postdata( $post ); 

                        ?>
                    
                    <div class="swiper-slide col-lg-4 col-md-4 col-xs-4 col-sm-12">
                        <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');"><a href="<?php if(get_sub_field('alternative_link_gaming')){echo get_sub_field('alternative_link_gaming'); }else{ echo the_permalink(); } ?>"></a></div>
                        <div class="text-container">
                            <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                            <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=1&finish=sentence&length_type=characters&ellipsis=&exclude_tags=img,p,strong,figure,video'); }  ?></div>
                        </div>
                    </div>
                    
                    <?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
                    <?php endif; ?>
                    
                    
                    <?php endwhile; ?>
                    <?php endif; ?>	
                    
                    
                </div>
            <a href="<?php echo get_field('link_gaming'); ?>" class="button button-fill button-cta" title="<?php echo get_field('cta_gaming'); ?>"><span><?php echo get_field('cta_gaming'); ?></span></a>
            
        </div>
    </div>
</section>


<section class="case-block" id="<?php echo get_field('id_partner'); ?>">
    <div class="section-title" style="background-image:url('<?php echo get_field('background_partner')['url']; ?>');">
        <div class="icon-image">
            <div class="outer-circle">
                <div class="inner-circle">
                    <div class="icon"><img src="<?php echo get_field('icon_partner')['url']; ?>" alt="icon"></div>
                </div>
            </div>
        </div>
        <h2 class="title"><?php echo get_field('title_partner'); ?></h2>
    </div>
    <div class="section-slider">
        
        <div class="slider-container container">
                <div class="row">
                    
                    
                    <?php if( have_rows('featured_gallery_partner') ): ?>
                    <?php while( have_rows('featured_gallery_partner') ): the_row();?>
                    
                    <?php

                    $post_object = get_sub_field('featured_partner');

                    if( $post_object ): 

                        // override $post
                        $post = $post_object;
                        setup_postdata( $post ); 

                        ?>
                    
                    <div class="swiper-slide col-lg-4 col-md-4 col-xs-4 col-sm-12">
                        <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');"><a href="<?php if(get_sub_field('alternative_link_partner')){echo get_sub_field('alternative_link_partner'); }else{ echo the_permalink(); } ?>"></a></div>
                        <div class="text-container">
                            <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                            <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=1&finish=sentence&length_type=characters&ellipsis=&exclude_tags=img,p,strong,figure,video'); }  ?></div>
                        </div>
                    </div>
                    
                    <?php wp_reset_postdata(); // IMPORTANT - reset the $post object so the rest of the page works correctly ?>
                    <?php endif; ?>
                    
                    
                    <?php endwhile; ?>
                    <?php endif; ?>	
                    
                    
                </div>
            <a href="<?php echo get_field('link_partner'); ?>" class="button button-fill button-cta" title="<?php echo get_field('cta_partner'); ?>"><span><?php echo get_field('cta_partner'); ?></span></a>
            
        </div>
    </div>
</section>


<?php echo get_template_part('parts/part', 'cta'); ?>
<?php get_footer('custom'); ?>