<?php
/*
	Template Name: Careers
*/

get_header('custom'); ?>

<?php 
    $side_image = explode("{:}", get_field('section_background', get_the_ID(),false));
    $langs = $side_image;

    foreach ($langs as $lang) {
        $phrase  = $side_image;
        $healthy = array("{:en}", "{:ja}", "{:zh}");
        $yummy   = array("", "");

        $newphrase = str_replace($healthy, $yummy, $phrase);
    }
    if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
?>
<?php if ( WPGlobus::Config()->language == 'ja' ) { 
  $bg = wp_get_attachment_url( ($newphrase[$num]) );
} else if ( WPGlobus::Config()->language == 'zh' ) { 
    $bg = wp_get_attachment_url( ($newphrase[$num]) );
} else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { 
  $bg = wp_get_attachment_url( ($newphrase[0]) );
} ?>

<section class="careers-title container-padding top-section" style="background-image:url('<?php echo $bg; ?>');">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h1 class="page-title"><?php echo get_field('info_title'); ?></h1>
                <p><?php echo get_field('info_description'); ?></p>
                <a href="<?php echo get_field('info_link'); ?>" class="button button-fill cta-button" title="<?php echo get_sub_field('cta'); ?>"><span><?php echo get_field('info_text'); ?></span></a>
            </div>
        </div>
    </div>
</section>


<section class="careers-description container-padding">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h2 class="title-teal"><?php echo get_field('second_section_title'); ?></h2>
                <?php echo get_field('second_section_description'); ?>
            </div>
        </div>
    </div>
</section>

<section class="careers-statistics">
    <div class="container">
        <div class="row">
            
            
            <?php if( have_rows('statistics') ): ?>
            <?php while( have_rows('statistics') ): the_row();?>
            
            <div class="col text-center statistic-data">
                <div class="link-item">
                    <div class="button-wrap">
                        <svg class="outer-circle-wrap" width="150" height="160" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="outer circle-outer-1" id="circle-outer-1" d="M59,5c30.38,0,56,24.62,56,55s-24.62,55-55,55S5,90.38,5,60S28.62,5,59,5z" fill-rule="nonzero" fill="#070707" />
                            <path class="outer blob-outer-1" id="blob-outer-1" d="M13.55,38.75C23.58,8.8,64.45,12.25,89.5,14.53c27.25,2.48,34.29,40.4,8.58,62.43 	c-18.64,15.98-35.86,41.94-59.19,28.38S-0.57,80.91,13.55,38.75z" fill-rule="nonzero" />
                        </svg>
                        <svg class="inner-circle-wrap" width="150" height="160" viewBox="0 0 120 120" xmlns="http://www.w3.org/2000/svg">
                            <path class="inner circle-inner-1" id="circle-inner-1" d="M59,15c24.85,0,46,20.15,46,45s-20.15,45-45,45S15,84.85,15,60S34.15,15,59,15z" fill-rule="nonzero" />
                            <path class="inner blob-inner-1" id="blob-inner-1" d="M10.27,59.49C30.64,39.13,25.28,6.97,58.51,11.26c26.42,3.41,33.22,14.83,42.88,39.66 c15.01,38.59-9.81,49.31-36.45,49.31S-8.57,78.33,10.27,59.49z" />
                        </svg>
                        <div class="button-touch"><?php echo get_sub_field('statistic'); ?></div>
                    </div>
                </div>
                <span class="title"><?php echo get_sub_field('description'); ?></span>
            </div>
            
            <?php endwhile; ?>
            <?php endif; ?>
            
        </div>
    </div>
</section>

<section class="careers-mission home-partners container-padding">
    <div class="container">
        <?php if( have_rows('mission') ): 
        $count = 0; ?>
            <?php while( have_rows('mission') ): the_row();?>
            
            <div class="row">
                <div class="table-row col <?php if($count == 1) { echo 'second-row'; }?>">
                    
                    
                    <?php 
                        $side_image2 = explode("{:}", get_sub_field('image', false));
                        $langs = $side_image2;

                        foreach ($langs as $lang) {
                            $phrase  = $side_image2;
                            $healthy = array("{:en}", "{:ja}", "{:zh}");
                            $yummy   = array("", "");

                            $newphrase = str_replace($healthy, $yummy, $phrase);
                        }
                        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                    ?>
                    
                    <?php if($count == 0) {?> <div class="cell cell-img col-md-6 col-sm-12 col-xs-12">
                        <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="img-partner"/>
                        <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="img-partner"/>
                        <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="img-partner"/>
                        <?php } ?>
                    </div>
                    <?php } ?>
                    <div class="cell cell-txt col-md-6 col-sm-12 col-xs-12 <?php if($count == 1) { echo 'second-row-content'; }?>">
                        <div class="wrap">
                            <h3 class="title-teal"><?php echo get_sub_field('title'); ?></h3>
                            <?php echo get_sub_field('content'); ?>
                        </div>
                    </div>
                    <?php if($count == 1) {?>
                    <div class="cell cell-img col-md-6 col-sm-12 col-xs-12 second-row-image">
                        <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="img-partner"/>
                        <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="img-partner"/>
                        <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="img-partner"/>
                        <?php } ?>
                    </div>
                    <?php } ?>
                </div>
            </div>
            <?php $count++; endwhile; ?>
        <?php endif; ?>
    </div>
</section>

<?php 
    $side_image4 = explode("{:}", get_field('glassdoor_background', get_the_ID(),false));
    $langs = $side_image4;

    foreach ($langs as $lang) {
        $phrase  = $side_image4;
        $healthy = array("{:en}", "{:ja}", "{:zh}");
        $yummy   = array("", "");

        $newphrase = str_replace($healthy, $yummy, $phrase);
    }
    if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
?>
<?php if ( WPGlobus::Config()->language == 'ja' ) { 
  $bg = wp_get_attachment_url( ($newphrase[$num]) );
} else if ( WPGlobus::Config()->language == 'zh' ) { 
    $bg = wp_get_attachment_url( ($newphrase[$num]) );
} else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { 
  $bg = wp_get_attachment_url( ($newphrase[0]) );
} ?>
<section class="careers-glassdoor container-padding" style="background-image: url('<?php echo $bg; ?>');">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h2><?php echo get_field('glassdoor_title'); ?></h2>
                <a href="<?php echo get_field('glassdoor_link'); ?>" target="_blank">
                    <?php 
                        $side_image3 = explode("{:}", get_field('glassdoor_logo',get_the_ID(), false));
                        $langs = $side_image3;

                        foreach ($langs as $lang) {
                            $phrase  = $side_image3;
                            $healthy = array("{:en}", "{:ja}", "{:zh}");
                            $yummy   = array("", "");

                            $newphrase = str_replace($healthy, $yummy, $phrase);
                        }
                        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                    ?>
                    <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="glassdoor-logo"/>
                    <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="glassdoor-logo"/>
                    <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="glassdoor-logo"/>
                    <?php } ?>
                </a>
            </div>
        </div>
    </div>
</section>

<section class="container-padding" id="jobs">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h2 class="title-teal"><?php echo get_field('jobs_title'); ?></h2>
                <p><?php echo get_field('jobs_description'); ?></p>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <?php echo get_field('jobs_iframe'); ?>
            </div>
        </div>
    </div>
</section>




<?php get_footer('custom'); ?>