<?php
/*
	Template Name: About
*/

get_header('custom'); ?>

<section class="about about-overview container-padding" id="<?php echo get_field('id1'); ?>">
    <div class="container">
        <div class="about-sidebar">
            <ul>
                
                <?php if( have_rows('sidebar') ): ?>
                <?php while( have_rows('sidebar') ): the_row();?>
                <li><a href="<?php echo get_sub_field('target_id'); ?>" class="scroll"><?php echo get_sub_field('label'); ?></a></li>
                <?php endwhile; ?>
                <?php endif; ?>	
                
            </ul>
        
        </div>
        <div class="about-content">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <h2 class="title-teal"><?php echo get_field('intro_title'); ?></h2>
                    <?php echo get_field('intro_content'); ?>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <?php 
                        $side_image = explode("{:}", get_field('intro_image', get_the_ID(),false));
                        $langs = $side_image;
                        
                        foreach ($langs as $lang) {
                            $phrase  = $side_image;
                            $healthy = array("{:en}", "{:ja}", "{:zh}");
                            $yummy   = array("", "");
                            $newphrase = str_replace($healthy, $yummy, $phrase);
                        }
                        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                    ?>
                    <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt=""/>
                    <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt=""/>
                    <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt=""/>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="about about-invest dark-bg container-padding" id="<?php echo get_field('id2'); ?>">
    <div class="container">
        <div class="about-content">
            <div class="row justify-content-between">
                <div class="col-lg-5">
                    <h2 class="title-teal"><?php echo get_field('invest_title'); ?></h2>
                    <?php echo get_field('invest_content'); ?>
                    <a href="<?php echo get_field('invest_link'); ?>" class="cta-link teal"><?php echo get_field('invest_text'); ?></a>
                </div>
                <div class="col-lg-6">
                    <div class="photo-wrapper">
                        <?php 
                        $side_image2 = explode("{:}", get_field('invest_image', get_the_ID(),false));
                        $langs = $side_image2;
                        foreach ($langs as $lang) {
                            $phrase  = $side_image2;
                            $healthy = array("{:en}", "{:ja}", "{:zh}");
                            $yummy   = array("", "");
                            $newphrase = str_replace($healthy, $yummy, $phrase);
                        }
                        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                    ?>
                    <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="preview-images"/>
                    <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="preview-images"/>
                    <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="preview-images"/>
                    <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="about about-team container-padding" id="<?php echo get_field('id3'); ?>">
    <div class="container">
        <div class="about-content">
            <div class="row">
                <div class="col">
                    <h2 class="title-teal"><?php echo get_field('team_title'); ?></h2>
                    <?php echo get_field('team_content'); ?>
                    <a href="<?php echo get_field('team_link'); ?>" class="cta-link"><?php echo get_field('team_text'); ?></a>
                    <?php 
                        $side_image3 = explode("{:}", get_field('team_image', get_the_ID(),false));
                        $langs = $side_image3;
                        
                        foreach ($langs as $lang) {
                            $phrase  = $side_image3;
                            $healthy = array("{:en}", "{:ja}", "{:zh}");
                            $yummy   = array("", "");
                            
                            $newphrase = str_replace($healthy, $yummy, $phrase);
                        }
                        if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                    ?>
                    <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="preview-images"/>
                    <?php } else if ( WPGlobus::Config()->language == 'zh' ) { ?>
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="preview-images"/>
                    <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                      <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="preview-images"/>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="about about-news container-padding" id="<?php echo get_field('id4'); ?>">
    <div class="container">
        <div class="about-content">
            <div class="row">
                <div class="col">
                    <h2 class="title-teal"><?php echo get_field('news_title'); ?></h2>
                    <?php echo get_field('news_content'); ?>
                    <a href="<?php echo get_field('news_link'); ?>" class="cta-link"><?php echo get_field('news_link_text'); ?></a>
                    <?php                 
                    $initiallist = new WP_Query(array(
                        'orderby'           => 'date', 
                        'posts_per_page'    => 3,
                        'post_type'         => array('news'),
                    )); 

                    if($initiallist->have_posts()): while($initiallist->have_posts()) : $initiallist->the_post();

                    ?>
                    <article class="news first">
                        <div class="row">
                            <div class="col-lg-3 col-md-4 col-sm-5 col-xs-12 image" style="background-image: url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');"><a href="<?php echo the_permalink(); ?>"></a></div>
                            <div class="col-lg-9 col-md-8 col-sm-7 col-xs-12 content">
                                <div class="title-black"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></div>
                                <p><?php echo the_advanced_excerpt('length=186&ellipsis=%26hellip;&exclude_tags=img,p,strong') ?></p>
                            </div>
                        </div>
                    </article>
                    <?php endwhile; wp_reset_postdata(); endif; ?>	
                </div>
            </div>
        </div>
    </div>
</section>


<section class="about about-leadership dark-bg container-padding" id="<?php echo get_field('id5'); ?>">
    <div class="container">
        <div class="about-content">
            <div class="row">
                <div class="col">
                    <h2 class="title-teal"><?php echo get_field('leadership_title'); ?></h2>
                    <?php echo get_field('leadership_content'); ?>
                </div>
            </div>

			<div class="row">
                <div class="col">
                    <ul class="leader-list row">
                        <?php if( have_rows('leadership_team_members') ): 
                        $count = 0; ?>
                            <?php while( have_rows('leadership_team_members') ): the_row();?>
                            <li class="col-lg-4 col-md-4 col-sm-6 col-xs-12" data-toggle="modal" data-target="#leadership-<?php echo $count; ?>">
                                <div class="list-wrap">
                                    <div class="name"><?php echo get_sub_field('name'); ?></div>
                                    <div class="position"><?php echo get_sub_field('position'); ?></div>
                                </div>
                            </li>
                            <?php $count++; endwhile; ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
                
            <div class="row">
                <div class="col">
                    <div class="title-white">Board of Directors</div>
                    <ul class="board-list row">
                        <?php if( have_rows('board_of_directors') ): 
                        $count = 0; ?>
                            <?php while( have_rows('board_of_directors') ): the_row();?>
                            <li class="col-lg-4 col-md-4 col-sm-6 col-xs-12" data-toggle="modal" data-target="#director-<?php echo $count; ?>">
                                <div class="list-wrap">
                                    <div class="name"><?php echo get_sub_field('name'); ?></div>
                                    <div class="position"><?php echo get_sub_field('position'); ?></div>
                                </div>
                            </li>
                            <?php $count++; endwhile; ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
            
        </div>
    </div>
</section>

<?php echo get_template_part('parts/part', 'contact'); ?>
<?php echo get_template_part('parts/part', 'modal'); ?>
<?php get_footer('custom'); ?>