jQuery(document).ready(function($) {
    function screen_width() {
		return $(window).width();
	}
    
    function debounce(func, wait, immediate) {
		var timeout;
		return function() {
			var context = this, args = arguments;
			var later = function() {
				timeout = null;
				if (!immediate) func.apply(context, args);
			};

			var callNow = immediate && !timeout;
			clearTimeout(timeout);
			timeout = setTimeout(later, wait);
			if (callNow) func.apply(context, args);
		};
	}
    
    var old_menu_item;
    var new_menu_item;
	
    
    // * Main Menu
    
    $('.showcase-nav > a').on('click', function(e){
        e.preventDefault();
        window.location.hash = this.hash;
        
        // * First remove all 'active' then  add the 
        // * 'active' class to the clicked menu item
        
        new_menu_item = this.hash;
        
        
        remove_active('.showcase-nav a');
        $(this).addClass('active');
        
        if(old_menu_item == new_menu_item) {
            // $(this.hash).toggle();

            if( $(this.hash).css('display') == 'none' ) {
                $(this.hash).show();
            } else {
                $(this.hash).hide();
            }
        } else {
            $('.verticals-container').removeAttr('style');
        }
        
        $('.verticals-container').removeClass('show');
        
        old_menu_item = new_menu_item;
        
        // * Show videos depending on the menu item
        
        show_videos(this.hash);
        
        // * Only to be seen on mobile devices.
        
        add_placeholder(this.innerText, 'main', 'click');
        
        // * Show verticals menu button. Mobile devices behaviour only.
        
        verticals_mobile(this.hash);
    });

    // * Sub Menu
    
    $('.verticals-menu-item a').click(function(e){
        e.preventDefault();
        window.location.hash = this.hash;
        
        // * First remove all 'active' then add the 
        // * 'active' class to the clicked menu item
       
        remove_active('.verticals-menu-item a'); 
        $(this).addClass('active');
        // * Once again sort the videos according
        // * to the clicked sub menu item
        
        sort_videos(this.hash);
        
        // * Only to be seen on mobile devices.
        
        add_placeholder(this.innerText, 'sub', 'click');
    });
	
	$('button.navigation-children').click(function(e){
		var link = window.location.hash.split("#")[1];
		$('.verticals-menu-item a.' + link).parent("span").parent("div").parent("div").parent("div").toggleClass("display-block-xs");
	});
	
	
    function remove_active(selector) {
        $(selector).removeClass('active', 'click');
    }
    
    function show_videos(hash) {
        if(hash == '#') {
            $('.videos-container a .video-thumb').each(function(){
                $(this).removeAttr('style');
            });          
        } else {
            sort_videos(hash);
        }
    }
    
    function sort_videos(hash) {
        hash = hash.replace("#", "");
        
        $('.videos-container .video-thumb').each(function(){
            if(!($(this).hasClass(hash))) {
                $(this).attr('style', 'display: none;');
            } else {
                $(this).removeAttr('style');
            }
            
            if($(this).hasClass("dont-none")){
                $(this).removeAttr('style');
            }
            
        });
    }
    
    function add_placeholder(selected_menu_item, which_placeholder, click_load) {
        if(which_placeholder == 'main') {
            $('.placeholder-vertical').text(' ');
            $('.placeholder-cat').text(selected_menu_item);
            
            if((screen_width() < 768) && (click_load == 'click')) {
                $('.navbar-category-main').trigger('click');
            }
        } else {
            $('.placeholder-vertical').text(selected_menu_item);
            
            if((screen_width() < 768) && (click_load == 'click')) {
                $('.navbar-header-verticals .navbar-toggle').trigger('click');
            }
        }
    }
    
    function verticals_mobile(hash) {
        if(screen_width() < 768) {
			
            if(hash.length > 0) {
                $('.navbar-header-verticals').addClass('active');
            } 
			
			if (hash.length == 0 || $(hash).hasClass('mobile-disabled')) {
                $('.navbar-header-verticals').removeClass('active');
            }
			
			
        }
    }
    
    
    function initial_load(hash) {
        
        if(hash != '') {

            target_hash = 'a[href="'+ hash + '"]';

            target_hash_parent = $(target_hash).parents('.verticals-container');

            target_hash_child = $('.verticals-container' + hash);

            if($(target_hash_parent).length > 0) {

                if( $('#' + hash).css('display') == 'none' ) {
                    $('#' + hash).show();
                } else {
                    $('#' + hash).hide();
                }

                if(screen_width() > 768) {

                    target_hash_parent.show();

                }

                remove_active('.showcase-nav a');

                $('.showcase-nav a[href="#' + target_hash_parent[0].id + '"]').addClass('active');

                show_videos(hash);

                add_placeholder($('.showcase-nav a[href="#' + target_hash_parent[0].id + '"]')[0].innerText, 'main', 'load');

                add_placeholder($(target_hash)[0].innerText, 'sub', 'load');


            } else {

                remove_active('.showcase-nav a');

                target_hash_child.show();

                sort_videos(hash);

                add_placeholder($('.showcase-nav a[href="' + hash + '"]')[0].innerText, 'main', 'load');

            }

            if(screen_width() < 768) {

                $('.navbar-header-verticals').addClass('active');

            }

            $(target_hash).addClass('active');
        
        }
        
    }
    
    // * Functions that must be called on resize
    
	$(window).resize(debounce(function() {
        
        verticals_mobile(window.location.hash);
        
	}, 250));
    
    // * Functions that must be called on load
    
    initial_load(window.location.hash);
});


if (location.hash) {
    window.scrollTo(0, 0);
    setTimeout(function() {
        window.scrollTo(0, 0);
    }, 1);
}