<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9" <?php language_attributes(); ?>> <![endif]-->
<!--[if gt IE 8]>      <html class="no-js" <?php language_attributes(); ?>> <![endif]-->
<html <?php language_attributes(); ?>>
	<head>
        <!-- Google Tag Manager -->
        <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
        new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
        j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
        'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','GTM-WBVKL6');</script>
        <!-- End Google Tag Manager -->
		<meta charset="<?php bloginfo('charset'); ?>">
		<title><?php wp_title(' | ', true, 'right'); ?></title>
		<meta name="description" content="<?php bloginfo('description'); ?>">
		<?php if (isset($_SERVER['HTTP_USER_AGENT'])&&(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false)){ header('X-UA-Compatible: IE=edge,chrome=1'); } ?>
		<meta name="viewport" content="width=device-width">
		<link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/img/favicon.png">
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.4.6/css/swiper.min.css">
        <link href="<?php bloginfo('template_url'); ?>/css/vendor/fontawesome.css" rel="stylesheet">
		<link rel="stylesheet" href="<?php echo get_stylesheet_uri(); ?>">
        <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/css/three-col-panel.css" type="text/css" media="screen" />
        <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/css/haptic-resource-new.css" type="text/css" media="screen" />
		<noscript>
			<link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/css/nojs.css">
		</noscript>
		<script src="<?php echo get_template_directory_uri(); ?>/js/vendor/modernizr-2.6.2-respond-1.1.0.min.js"></script>
		<script src="https://content.jwplatform.com/libraries/jZ4ac4UP.js"></script>
		<?php wp_head(); ?>
		
	</head>
	<body <?php body_class(); ?>>
        <!-- Google Tag Manager (noscript) -->
        <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-WBVKL6"
        height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
        <!-- End Google Tag Manager (noscript) -->
        
        
    <!-- Header -->
    <header>
        <div class="wave wave-1"></div>
        <div class="wave wave-2"></div>
        <div class="container">
            <div class="row">
                <!-- <div class="logo col-lg-3"> -->
                <div class="logo">
                   <a href="<?php echo get_site_url(); ?>"><img src="<?php echo get_field('website_logo', 'options')['url']; ?>" alt="Immersion"></a>
                </div>
                <div class="menu-button col-auto mr-auto">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <div class="search-button col-auto mr-auto">
                    <img class="search" src="<?php echo get_site_url() . '/wp-content/themes/immersion/images/search.png'; ?>" alt="Search Icon" />
                </div>
                <!-- <nav class="menu col-lg-9"> -->
                <nav class="menu">
                    <?php 
                        wp_nav_menu( array(
                            'menu'           => 'Main Menu', // Do not fall back to first non-empty menu.
                        ) );
                    ?>
                </nav>
            </div>
        </div>
    </header>
    <div class="search-window">
        <div class="container">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">×</span>
            </button>
            <form role="search" method="get" id="searchform" class="searchform" action="<?php echo get_site_url(); ?>">
                <div>
                    <input type="text" value="" name="s" id="s" placeholder="Search for..." autocomplete="off">
                    <input type="submit" id="searchsubmit" value="Search">
                </div>
            </form>
        </div>
    </div>