<?php

add_action('after_setup_theme', 'boilerplate_setup');
function boilerplate_setup() {
    load_theme_textdomain('boilerplate', get_template_directory() . '/languages');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
    global $content_width;
    if ( ! isset( $content_width ) ) $content_width = 640;
    register_nav_menus(
        array( 'main-menu' => __( 'Main Menu', 'boilerplate' ) )
    );
}

add_action('wp_enqueue_scripts', 'boilerplate_load_scripts');
function boilerplate_load_scripts() {
    
    //Scripts
    wp_enqueue_script('jquery');
    wp_enqueue_script( 'detectizr', 'https://cdnjs.cloudflare.com/ajax/libs/detectizr/2.2.0/detectizr.min.js', array('jquery') , false, true );
    
    if ( is_front_page() || is_page('technology') || is_page('use-cases') || is_page('partners')) {	
        wp_enqueue_script( 'snap', 'https://cdnjs.cloudflare.com/ajax/libs/snap.svg/0.5.1/snap.svg-min.js', array('jquery') , false, true );
        wp_enqueue_script( 'svgbuttons', get_stylesheet_directory_uri() . '/js/svg-btn.js', array('jquery') , false, true );
    }
    
    if (is_page('careers') || is_page_template('page-experience.php')) {
        wp_enqueue_script( 'snap', 'https://cdnjs.cloudflare.com/ajax/libs/snap.svg/0.5.1/snap.svg-min.js', array('jquery') , false, true );
        wp_enqueue_script( 'svgbuttons', get_stylesheet_directory_uri() . '/js/svg-btn.js', array('jquery') , false, true );
    }
    
    //* Particles JS
    if (is_page('innovations')) {
        wp_enqueue_script( 'innovation', get_stylesheet_directory_uri() . '/js/innovations.js', '', null, true);
        wp_enqueue_script( 'particle-js', 'https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js', array('jquery') , false, true );
    }

    if ( is_front_page() ) {	
        // wp_enqueue_script( 'wheel', get_stylesheet_directory_uri() . '/js/wheel-detector.js', array('jquery') , false, true );
        // wp_enqueue_style( 'shakecss', get_stylesheet_directory_uri() . '/css/shake.css', array(), '1.0' );
    }	
    
    if ( is_page('partners') ) {
        wp_enqueue_script( 'anitabs', get_stylesheet_directory_uri() . '/js/anitabs.min.js', array('jquery') , false, true );
        wp_enqueue_script( 'partners', get_stylesheet_directory_uri() . '/js/partners.js', array('jquery') , false, true );
        wp_enqueue_style( 'tabs', get_stylesheet_directory_uri() . '/css/anitabs.css', array(), '1.0' );
    }
    
    if(is_page('legal')) {
        wp_dequeue_script( 'main' );
        wp_enqueue_script( 'tabjs', get_stylesheet_directory_uri() . '/js/legal.js', array('jquery') , false, true );
    }
    
    if(is_page('technology')) {
        wp_enqueue_style( 'technology-css', get_stylesheet_directory_uri() . '/css/technology.css', array(), '1.0' );
    }
    
    if( is_singular('showcase_video') || is_singular('showcase_gallery') ) {
        wp_enqueue_style( 'video-css', get_stylesheet_directory_uri() . '/css/video-showcase.css', array(), '1.0' );
        wp_enqueue_script( 'video-js', get_stylesheet_directory_uri() . '/js/video-showcase.js', array('jquery') , false, true );
    }
    
    $local_vars = [
		'site_url'	=> site_url()
	];
	wp_localize_script( 'wheel', 'imm_app', $local_vars );
    
    //Styles
    wp_enqueue_style( 'google-font', '//fonts.googleapis.com/css?family=Lato:300,300i,400,400i,700,700i,900,900i', array() );
    wp_enqueue_style( 'maincss', get_bloginfo( 'stylesheet_directory' ) . '/css/main.css', array(), filemtime( get_stylesheet_directory() . '/css/main.css' ) );
    wp_enqueue_style( 'default', get_bloginfo( 'stylesheet_directory' ) . '/css/default.css', array() );
    
    //Swiper
    wp_enqueue_style( 'swiper', 'https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.5.0/css/swiper.min.css' );
    wp_enqueue_script( 'swiper', 'https://cdnjs.cloudflare.com/ajax/libs/Swiper/4.5.0/js/swiper.min.js', array('jquery') );
    
    //Script
    wp_enqueue_script( 'matchheight', get_stylesheet_directory_uri() . '/js/jquery.matchHeight.js', array('jquery') , false, true );
    wp_enqueue_script( 'swiper-custom', get_stylesheet_directory_uri() . '/js/swiper.js', array('jquery') , false, true );
    
    if ( is_front_page() ) {	
        wp_enqueue_style( 'banner', get_stylesheet_directory_uri() . '/css/homepage.css', array(), '1.0' );
    }	
}

add_action('comment_form_before', 'boilerplate_enqueue_comment_reply_script');
function boilerplate_enqueue_comment_reply_script() {
    if (get_option('thread_comments')) { 
        wp_enqueue_script('comment-reply'); 
    }
}

add_filter('the_title', 'boilerplate_title');
function boilerplate_title($title) {
    if ($title == '') {
        return '&rarr;';
    } else {
        return $title;
    }
}

add_filter('wp_title', 'boilerplate_filter_wp_title');
function boilerplate_filter_wp_title($title) {
    return $title . esc_attr(get_bloginfo('name'));
}

add_action('widgets_init', 'boilerplate_widgets_init');
function boilerplate_widgets_init() {
    register_sidebar( array (
    'name' => __('Sidebar Widget Area', 'boilerplate'),
    'id' => 'primary-widget-area',
    'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
    'after_widget' => "</li>",
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
    ) );
}

function boilerplate_custom_pings($comment) {
    $GLOBALS['comment'] = $comment;
?>
    <li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>"><?php echo comment_author_link(); ?></li>
<?php 
}

add_filter('get_comments_number', 'boilerplate_comments_number');
function boilerplate_comments_number($count) {
    if (!is_admin()) {
        global $id;
        $comments_by_type = &separate_comments( get_comments( 'status=approve&post_id=' . $id ) );
        return count($comments_by_type['comment']);
    } else {
        return $count;
    }
}

//Add ACF Options Page
if( function_exists('acf_add_options_page') ) {
	
	acf_add_options_page(array(
		'page_title' 	=> 'General Settings',
		'menu_title'	=> 'Theme Settings',
		'menu_slug' 	=> 'theme-general-settings',
		'capability'	=> 'edit_posts',
		'redirect'		=> false
	));
	
	acf_add_options_sub_page(array(
		'page_title' 	=> 'Theme Logo Settings',
		'menu_title'	=> 'Logo',
		'parent_slug'	=> 'theme-general-settings',
	));
	
	acf_add_options_sub_page(array(
		'page_title' 	=> 'Theme Header Settings',
		'menu_title'	=> 'Header',
		'parent_slug'	=> 'theme-general-settings',
	));
	
	acf_add_options_sub_page(array(
		'page_title' 	=> 'Theme Footer Settings',
		'menu_title'	=> 'Footer',
		'parent_slug'	=> 'theme-general-settings',
	));
    
    acf_add_options_sub_page(array(
		'page_title' 	=> 'Innovation Settings',
		'menu_title'	=> 'Innovation',
		'parent_slug'	=> 'theme-general-settings',
	));
	
    
    acf_add_options_sub_page(array(
		'page_title' 	=> 'Contact Settings',
		'menu_title'	=> 'Contact',
		'parent_slug'	=> 'theme-general-settings',
	));
    
    acf_add_options_sub_page(array(
		'page_title' 	=> 'Sidebar Settings',
		'menu_title'	=> 'Sidebar',
		'parent_slug'	=> 'theme-general-settings',
	));
}


// Assign Posts per page for custom query with pagination
function custom_posts_per_page( $query ) {

	//* Blog
    if ( !is_admin() || $query->is_main_query() ) {
    	if( is_page('corporate') ) {
//	        $query->set( 'post_type', 'post' );
	        $query->set( 'posts_per_page', 10 );
	    }
	    else if( is_tax('use_cases_category') ) {
	        $query->set( 'posts_per_page', 9 );
	    }
    }
}
add_action( 'pre_get_posts', 'custom_posts_per_page' );


// Create Widget
function arphabet_widgets_init() {

	register_sidebar( array(
		'name'          => 'Archive Sidebar',
		'id'            => 'archive_sidebar',
		'before_widget' => '<div class="sidebar-block">',
		'after_widget'  => '</div>'
	) );
    register_sidebar( array(
		'name'          => 'Blog Sidebar',
		'id'            => 'blog_sidebar',
		'before_widget' => '<div class="sidebar-block">',
		'after_widget'  => '</div>'
	) );

}
add_action( 'widgets_init', 'arphabet_widgets_init' );


// Get XML for Press Release in News Page
function get_xml_from_url($url){
  $ch = curl_init();

  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');

  $xmlstr = curl_exec($ch);
  curl_close($ch);

  return $xmlstr;
}

//* Posts 2 Posts - Create Connections
function my_connection_types() {
	p2p_register_connection_type( array(
		'name' => 'posts_to_pages',
		'from' => 'showcase_video',
		'to' => 'showcase_gallery',
		'admin_box' => array(
            'show' => 'any',
            'context' => 'advanced'
          )
	) );
}
add_action( 'p2p_init', 'my_connection_types' );

//* Change slugs
function custom_parse_request_tricksy( $query ) {
    // Only noop the main query
    if ( ! $query->is_main_query() )
        return;

    // Only noop our very specific rewrite rule match
    if ( 2 != count( $query->query ) || ! isset( $query->query['page'] ) ) {
        return;
    }

    // 'name' will be set if post permalinks are just post_name, otherwise the page rule will match
    if ( ! empty( $query->query['name'] ) ) {
        $query->set( 'post_type', array( 'showcase_gallery','post','page') );
    }
}
add_action( 'pre_get_posts', 'custom_parse_request_tricksy' );

//* Remove slug of Showcase Galleries
 function custom_remove_cpt_slug( $post_link, $post, $leavename ) {
    if ( 'showcase_gallery' != $post->post_type  || 'publish' != $post->post_status ) {
        return $post_link;
    }
    $post_link = str_replace( '/' . $post->post_type . '/', '/', $post_link );
    return $post_link;
}
add_filter( 'post_type_link', 'custom_remove_cpt_slug', 10, 3 ); 


//* Rewrite slug of Showcase Video to Haptic Web Gallery
add_filter( 'register_post_type_args', 'wpse247328_register_post_type_args', 10, 2 );
function wpse247328_register_post_type_args( $args, $post_type ) {
    if ( 'showcase_video' === $post_type ) {
        $args['rewrite']['slug'] = 'haptic-web-gallery';
    }
    return $args;
}

//* Add CSS on admin
function load_custom_wp_admin_style() {
        wp_register_style( 'custom_wp_admin_css', get_template_directory_uri() . '/css/admin-style.css', false, '1.0.0' );
        wp_enqueue_style( 'custom_wp_admin_css' );
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_style' );

// Add category slug
function get_cat_slug($cat_id) {
	$cat_id = (int)$cat_id;
	$category = &get_category($cat_id);
	return $category->slug;
}

function wpse_posts_where( $where ) {
    global $wpdb;
    
    // Run this filter callback only once:
    remove_filter( current_filter(), __FUNCTION__ );

    // Modify this to your needs:  
    $cpt1       = 'news';     
    $cpt2       = 'post';    
    $taxonomy   = 'category'; // Related to cpt2
    // $term_slug  = 'insights';  // Related to cpt2  

    $terms = get_field('articles_categories');
    $catID = implode(', ', $terms);

    // Modify the SQL query:
    if( ! is_wp_error( $term ) ) {
        $where .= " AND ( {$wpdb->posts}.post_type = '{$cpt1}' 
            OR {$wpdb->posts}.post_type = '{$cpt2}' 
            AND {$wpdb->posts}.post_status = 'publish'
            AND {$wpdb->posts}.ID IN (
                SELECT object_id FROM {$wpdb->term_relationships} 
                WHERE term_taxonomy_id IN ( $catID ) ) ) ";
    }
    return $where;
    
}