<?php get_header('custom'); ?>

<section class="container-padding top-section">
    <div class="container">
        <div class="row">
            <h1 class="entry-title page-title title-teal text-center"><?php echo post_type_archive_title(); ?></h1>
        </div>
        <div class="row">
            <div class="col-lg-9 col-md-9 col-sm-8 col-xs-12">
            
                <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                
                <article <?php post_class('archive-article'); ?>>
                    <div class="row">
                        <div class="col-lg-2 col-md-3 col-sm-12">
                            <span class="date"><?php echo get_the_date(); ?></span>
                            <div class="image-container small-image">
                                <a href="<?php echo the_permalink(); ?>">
                                    <img src="<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>">
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-10 col-md-9 col-sm-12">
                            <h2 class="title-teal"><a href="<?php echo the_permalink(); ?>"><?php the_title(); ?></a></h2>
                            <div class="image-container">
                                <a href="<?php echo the_permalink(); ?>">
                                    <img src="<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>">
                                </a>
                            </div>
                            <div class="excerpt-container"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=230&length_type=characters&ellipsis=%26hellip;&exclude_tags=img,p,strong,a,h1,h2,h3,h4,h5,h6'); }  ?>
                            <div class="read-more"><a class="cta-link" href="<?php echo the_permalink(); ?>">Read More</a></div>
                            </div>
                            
                        </div>
                    </div>
                </article>
                
                <?php endwhile; the_posts_pagination(array('screen_reader_text' => ' ')); endif; ?>

            </div>
            <div class="col-lg-3 col-md-3 col-sm-4 col-xs-12 sidebar">
                <?php dynamic_sidebar( 'archive_sidebar' ); ?>
            </div>
        </div>
    </div>
</section>

<?php get_footer('custom'); ?>